/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.netstorage.cli;

import com.akamai.netstorage.DefaultCredential;
import com.akamai.netstorage.NetStorage;
import com.akamai.netstorage.NetStorageException;
import com.akamai.netstorage.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class CMS {
    public static void main(String[] args) throws Exception {
        String action = null;
        String user = null;
        String key = null;
        String netstorageURI = null;
        String uploadfile = null;
        String outputfile = null;
        String targetFilename = null;
        String dstFilename = null;
        boolean indexZip = false;
        String firstarg = null;
        for (String arg : args) {
            if (firstarg != null) {
                switch (firstarg) {
                    case "-h": {
                        CMS.help();
                        return;
                    }
                    case "-a": {
                        action = arg;
                        break;
                    }
                    case "-u": {
                        user = arg;
                        break;
                    }
                    case "-k": {
                        key = arg;
                        break;
                    }
                    case "-o": {
                        outputfile = arg;
                        break;
                    }
                    case "-f": {
                        uploadfile = arg;
                        break;
                    }
                    case "-t": {
                        targetFilename = arg;
                        break;
                    }
                    case "-d": {
                        dstFilename = arg;
                    }
                }
                firstarg = null;
                continue;
            }
            if (arg.equals("-indexzip")) {
                indexZip = true;
                continue;
            }
            if (!arg.startsWith("-")) {
                netstorageURI = arg;
                continue;
            }
            firstarg = arg;
        }
        CMS.execute(action, user, key, netstorageURI, uploadfile, outputfile, targetFilename, dstFilename, indexZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String action, String user, String key, String netstorageURI, String uploadfile, String outputfile, String target, String dst, boolean indexZip) throws NetStorageException, IOException {
        String host = null;
        String path = netstorageURI;
        if (netstorageURI == null || user == null || key == null) {
            File credsFile = new File(System.getProperty("user.home") + File.separator + ".edgerc");
            String section = "netstorage";
            Properties props = Utils.readIniSection(credsFile, section);
            host = props.getProperty("host");
            user = props.getProperty("username");
            key = props.getProperty("key");
        }
        if (action == null || netstorageURI == null || user == null || key == null) {
            CMS.help();
            return;
        }
        if (host == null) {
            String[] hostpath = netstorageURI.split("/", 2);
            host = hostpath[0];
            path = "/" + hostpath[1];
        }
        NetStorage ns = new NetStorage(new DefaultCredential(host, user, key));
        InputStream result = null;
        boolean success = true;
        switch (action) {
            case "delete": {
                success = ns.delete(path);
                break;
            }
            case "dir": {
                result = ns.dir(path);
                break;
            }
            case "download": {
                result = ns.download(path);
                break;
            }
            case "du": {
                result = ns.du(path);
                break;
            }
            case "mkdir": {
                success = ns.mkdir(path);
                break;
            }
            case "mtime": {
                success = ns.mtime(path);
                break;
            }
            case "rename": {
                if (dst == null) {
                    CMS.help();
                    return;
                }
                success = ns.rename(path, dst);
                break;
            }
            case "rmdir": {
                success = ns.rmdir(path);
                break;
            }
            case "stat": {
                result = ns.stat(path);
                break;
            }
            case "symlink": {
                if (target == null) {
                    CMS.help();
                    return;
                }
                success = ns.symlink(path, target);
                break;
            }
            case "upload": {
                if (uploadfile == null) {
                    CMS.help();
                    return;
                }
                success = ns.upload(path, new File(uploadfile), null, indexZip);
                break;
            }
            default: {
                CMS.help();
                return;
            }
        }
        if (result != null) {
            boolean usingStdOut;
            OutputStream output;
            if (outputfile != null) {
                output = new FileOutputStream(outputfile);
                usingStdOut = false;
            } else {
                output = System.out;
                usingStdOut = true;
            }
            try {
                int length;
                byte[] buffer = new byte[0x100000];
                while ((length = result.read(buffer)) > 0) {
                    output.write(buffer, 0, length);
                }
                output.flush();
            }
            finally {
                if (!usingStdOut) {
                    output.close();
                }
                result.close();
            }
        } else if (success) {
            System.out.println("Success.");
        } else {
            System.err.println("Error.");
        }
    }

    static void help() {
        System.err.println("\nUsage: cms <-a action> <-u user> <-k key>\n[-o outfile] [-f srcfile]\n[-t targetpath] [-d newpath]\n<-indexzip> <host/path>\n\nWhere:\naction          one of: delete, dir, download, du, mkdir, mtime, rename, rmdir, stat, symlink, upload\nuser            username defined in the Luna portal\nkey             unique key used to sign api requests\noutfile         local file name to write when action=download\nsrcfile         local file used as source when action=upload\ntargetpath      the absolute path (/1234/example.jpg) pointing to the existing target when action=symlink\nnewpath         the absolute path (/1234/example.jpg) for the new file when action=rename\nhost/path       the netstorage hostname and path to the file being manipulated (example.akamaihd.net/1234/example.jpg)\n\n\n Example: cms -a dir -u user1 -k 1234abcd example.akamaihd.net/1234\n\n\n");
    }
}

