/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.netstorage;

import com.akamai.netstorage.parameter.Parameter;
import com.akamai.netstorage.parameter.ParameterValueFormatter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class.getName());
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static byte[] computeHash(InputStream srcStream, HashAlgorithm hashAlgorithm) throws IOException {
        if (srcStream == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
            try (BufferedInputStream inputStream = new BufferedInputStream(srcStream);){
                int size;
                byte[] buff = new byte[0x100000];
                while ((size = ((InputStream)inputStream).read(buff)) != -1) {
                    digest.update(buff, 0, size);
                }
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("This should never happen! We are using an enum!", e);
        }
    }

    public static byte[] computeKeyedHash(byte[] data, String key, KeyedHashAlgorithm hashType) {
        if (data == null || key == null) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(hashType.getAlgorithm());
            mac.init(new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), hashType.getAlgorithm()));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("This should never happen!", e);
        }
    }

    public static String encodeHex(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (byte aValue : value) {
            str.append(String.format("%02x", aValue));
        }
        return str.toString();
    }

    public static String encodeBase64(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < value.length; i += 3) {
            int c = 2;
            int v = (value[i] & 0xFF) << 16;
            if (i + 1 < value.length) {
                v |= (value[i + 1] & 0xFF) << 8;
                c = 3;
            }
            if (i + 2 < value.length) {
                v |= value[i + 2] & 0xFF;
                c = 4;
            }
            result.append(BASE64_CHARS[v >> 18 & 0x3F]);
            result.append(BASE64_CHARS[v >> 12 & 0x3F]);
            result.append(c >= 3 ? BASE64_CHARS[v >> 6 & 0x3F] : (char)'=');
            result.append(c == 4 ? BASE64_CHARS[v & 0x3F] : (char)'=');
        }
        return result.toString();
    }

    public static Map<String, String> convertObjectAsMap(Object srcObj) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            PropertyDescriptor[] properties;
            BeanInfo beanInfo = Introspector.getBeanInfo(srcObj.getClass());
            for (PropertyDescriptor property : properties = beanInfo.getPropertyDescriptors()) {
                String name = property.getName();
                if (name.equals("class") || name.equals("additionalParams")) continue;
                ParameterValueFormatter formatter = null;
                boolean includeNull = false;
                Field field = srcObj.getClass().getDeclaredField(name);
                Parameter p = field.getAnnotation(Parameter.class);
                if (p != null && p.name() != null) {
                    name = p.name();
                    includeNull = p.includeNull();
                    try {
                        formatter = p.formatter().newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("This should never happen if you are implementing ParameterValueFormatter!", e);
                    }
                }
                String value = null;
                Object o = property.getReadMethod().invoke(srcObj, new Object[0]);
                if (o != null && formatter != null) {
                    value = formatter.valueOf(o);
                } else if (o != null) {
                    value = o.toString();
                }
                if (!includeNull && value == null) continue;
                resultMap.put(name, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            log.log(Level.SEVERE, "Object serialization error", e);
        }
        return resultMap;
    }

    public static String convertMapAsQueryParams(Map<String, String> data) {
        StringBuilder result = new StringBuilder();
        try {
            for (String entry : new TreeSet<String>(data.keySet())) {
                result.append(String.format("%s%s=%s", result.length() > 0 ? "&" : "", URLEncoder.encode(entry, StandardCharsets.UTF_8.name()), URLEncoder.encode(data.get(entry), StandardCharsets.UTF_8.name())));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("This should never happen! StandardCharsets.UTF_8 is an enum!", e);
        }
        return result.toString();
    }

    public static void readToEnd(InputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        byte[] buffer = new byte[0x100000];
        while (stream.read(buffer) > 0) {
        }
    }

    public static Properties readIniSection(File srcFile, String section) throws IOException {
        if (!srcFile.exists()) {
            throw new FileNotFoundException(String.format("Src file is not accessible %s", srcFile.toString()));
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(srcFile));){
            Properties properties = Utils.readIniSection(inputStream, section);
            return properties;
        }
    }

    public static Properties readIniSection(InputStream inputStream, String section) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            String content = new Scanner(bufferedInputStream).useDelimiter("\\Z").next();
            String data = "";
            Pattern regex = Pattern.compile(String.format("\\[%s\\](.+?)(\\[|\\z)", section), 32);
            Matcher regexMatcher = regex.matcher(content);
            if (regexMatcher.find()) {
                data = regexMatcher.group(1);
            }
            if (data == "" && !(regex = Pattern.compile("^\\[")).matcher(content).find()) {
                data = content;
            }
            Properties result = new Properties();
            result.load(new StringReader(data));
            Properties properties = result;
            return properties;
        }
    }

    public static enum KeyedHashAlgorithm {
        HMACMD5("HmacMD5"),
        HMACSHA1("HmacSHA1"),
        HMACSHA256("HmacSHA256");

        private final String algorithm;

        private KeyedHashAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }

    public static enum HashAlgorithm {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256");

        private final String algorithm;

        private HashAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

