/*
 * Decompiled with CFR 0.152.
 */
package com.ajts.androidmads.library;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelToSQLite {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private Context mContext;
    private SQLiteDatabase database;
    private String mDbName;

    public ExcelToSQLite(Context context, String dbName) {
        this.mContext = context;
        this.mDbName = dbName;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)this.mContext.getDatabasePath(this.mDbName).getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importFromAsset(final String assetFileName, final ImportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        ExcelToSQLite.this.working(ExcelToSQLite.this.mContext.getAssets().open(assetFileName));
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(ExcelToSQLite.this.mDbName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (ExcelToSQLite.this.database != null && ExcelToSQLite.this.database.isOpen()) {
                            ExcelToSQLite.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    public void importFromFile(String filePath, ImportListener listener) {
        this.importFromFile(new File(filePath), listener);
    }

    private void importFromFile(final File file, final ImportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        ExcelToSQLite.this.working(new FileInputStream(file));
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(ExcelToSQLite.this.mDbName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (ExcelToSQLite.this.database != null && ExcelToSQLite.this.database.isOpen()) {
                            ExcelToSQLite.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private void working(InputStream stream) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook(stream);
        int sheetNumber = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNumber; ++i) {
            this.createTable((Sheet)workbook.getSheetAt(i));
        }
        this.database.close();
    }

    private void createTable(Sheet sheet) {
        StringBuilder createTableSql = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createTableSql.append(sheet.getSheetName());
        createTableSql.append("(");
        Iterator rit = sheet.rowIterator();
        Row rowHeader = (Row)rit.next();
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < rowHeader.getPhysicalNumberOfCells(); ++i) {
            createTableSql.append(rowHeader.getCell(i).getStringCellValue());
            if (i == rowHeader.getPhysicalNumberOfCells() - 1) {
                createTableSql.append(" TEXT");
            } else {
                createTableSql.append(" TEXT,");
            }
            columns.add(rowHeader.getCell(i).getStringCellValue());
        }
        createTableSql.append(")");
        this.database.execSQL(createTableSql.toString());
        while (rit.hasNext()) {
            Row row = (Row)rit.next();
            ContentValues values = new ContentValues();
            for (int n = 0; n < row.getPhysicalNumberOfCells(); ++n) {
                if (row.getCell(n).getCellType() == 0) {
                    values.put((String)columns.get(n), Double.valueOf(row.getCell(n).getNumericCellValue()));
                    continue;
                }
                values.put((String)columns.get(n), row.getCell(n).getStringCellValue());
            }
            long result = this.database.insert(sheet.getSheetName(), null, values);
            if (result >= 0L) continue;
            throw new RuntimeException("insert value failed!");
        }
    }

    public static interface ImportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }
}

