/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.common.vo.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.service.service.WorkflowBatchService;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.WorkflowBatchQueryVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseWebVO;
import com.aizuda.snailjob.server.web.service.WorkflowWebBatchService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/batch"})
public class WorkflowBatchController {
    private final WorkflowWebBatchService workflowWebBatchService;
    @Qualifier(value="WorkflowWebBatchCommonService")
    private final WorkflowBatchService workflowBatchService;

    @LoginRequired
    @GetMapping(value={"/page/list"})
    public PageResult<List<WorkflowBatchResponseVO>> listPage(WorkflowBatchQueryVO queryVO) {
        return this.workflowWebBatchService.listPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public WorkflowDetailResponseWebVO getWorkflowBatchDetail(@PathVariable(value="id") Long id) {
        return (WorkflowDetailResponseWebVO)this.workflowBatchService.getWorkflowBatchById(id, WorkflowDetailResponseWebVO.class);
    }

    @PostMapping(value={"/stop/{id}"})
    @LoginRequired
    public Boolean stop(@PathVariable(value="id") Long id) {
        return this.workflowWebBatchService.stop(id);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean deleteByIds(@RequestBody @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") Set<Long> ids) {
        return this.workflowWebBatchService.deleteByIds(ids);
    }

    @Generated
    public WorkflowBatchController(WorkflowWebBatchService workflowWebBatchService, @Qualifier(value="WorkflowWebBatchCommonService") WorkflowBatchService workflowBatchService) {
        this.workflowWebBatchService = workflowWebBatchService;
        this.workflowBatchService = workflowBatchService;
    }
}

