/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.timer;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.enums.WebSocketSceneEnum;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import com.aizuda.snailjob.server.web.timer.LogTimerWheel;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import lombok.Generated;

public class RetryTaskLogTimerTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = "retryTaskLog_{0}_{1}_{2}";
    private RetryTaskLogMessageQueryVO logQueryVO;
    private String sid;

    public void run(Timeout timeout) throws Exception {
        SnailJobLog.LOCAL.debug("Start querying scheduled task logs. Current time:[{}] retryTaskId:[{}]", new Object[]{LocalDateTime.now(), this.logQueryVO.getRetryTaskId()});
        try {
            LogTimerWheel.clearCache(this.idempotentKey());
            RetryTaskService logService = (RetryTaskService)SnailSpringContext.getBean(RetryTaskService.class);
            logService.getRetryTaskLogMessagePage(this.logQueryVO);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Scheduled task log query execution failed", new Object[]{e});
        }
    }

    public String idempotentKey() {
        Long taskId = this.logQueryVO.getRetryTaskId();
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.sid, WebSocketSceneEnum.JOB_LOG_SCENE, taskId);
    }

    @Generated
    public RetryTaskLogTimerTask(RetryTaskLogMessageQueryVO logQueryVO, String sid) {
        this.logQueryVO = logQueryVO;
        this.sid = sid;
    }
}

