/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.convert;

import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.PointInTimeDTO;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.web.model.response.JobResponseWebVO;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface JobResponseVOConverter {
    public static final JobResponseVOConverter INSTANCE = (JobResponseVOConverter)Mappers.getMapper(JobResponseVOConverter.class);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIds(job.getNotifyIds()))")})
    public List<JobResponseWebVO> convertList(List<Job> var1);

    @Mappings(value={@Mapping(target="nextTriggerAt", expression="java(JobResponseVOConverter.toLocalDateTime(job.getNextTriggerAt()))"), @Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIds(job.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(JobResponseVOConverter.toTriggerInterval(job))"), @Mapping(target="ownerId", expression="java(JobResponseVOConverter.getOwnerId(job))")})
    public JobResponseWebVO convert(Job var1);

    public static Long getOwnerId(Job job) {
        return Objects.nonNull(job.getOwnerId()) && job.getOwnerId() > 0L ? job.getOwnerId() : null;
    }

    public static LocalDateTime toLocalDateTime(Long nextTriggerAt) {
        if (Objects.isNull(nextTriggerAt) || nextTriggerAt == 0L) {
            return null;
        }
        return DateUtils.toLocalDateTime((Long)nextTriggerAt);
    }

    public static String toTriggerInterval(Job job) {
        String triggerInterval = job.getTriggerInterval();
        Integer triggerType = job.getTriggerType();
        if (WaitStrategies.WaitStrategyEnum.POINT_IN_TIME.getType().equals(triggerType)) {
            List pointInTimeDTOS = JsonUtil.parseList((String)triggerInterval, PointInTimeDTO.class);
            List<String> timeStrList = pointInTimeDTOS.stream().map(time -> DateUtils.format((LocalDateTime)DateUtils.toLocalDateTime((Long)time.getTime()))).toList();
            return JsonUtil.toJsonString(timeStrList);
        }
        return triggerInterval;
    }
}

