/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.dto.TaskStopJobDTO;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import com.aizuda.snailjob.server.web.service.convert.RetryConverter;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskLogResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryTaskServiceImpl
implements RetryTaskService {
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    private final RetryTaskStopHandler retryTaskStopHandler;

    @Override
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskLogPage(RetryTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetryTask::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryTask::getSceneName, (Object)queryVO.getSceneName())).eq(queryVO.getTaskStatus() != null, RetryTask::getTaskStatus, (Object)queryVO.getTaskStatus())).eq(Objects.nonNull(queryVO.getRetryId()), RetryTask::getRetryId, (Object)queryVO.getRetryId())).between(ObjUtil.isNotNull((Object)queryVO.getDatetimeRange()), CreateDt::getCreateDt, (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).select(new SFunction[]{RetryTask::getGroupName, RetryTask::getId, RetryTask::getSceneName, RetryTask::getTaskStatus, CreateDt::getCreateDt, RetryTask::getTaskType, RetryTask::getOperationReason, RetryTask::getRetryId}).orderByDesc(CreateDt::getCreateDt);
        PageDTO retryTaskPageDTO = (PageDTO)this.retryTaskMapper.selectPage((IPage)pageDTO, (Wrapper)wrapper);
        return new PageResult<List<RetryTaskResponseVO>>(retryTaskPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.convertList(retryTaskPageDTO.getRecords()));
    }

    @Override
    public RetryTaskLogMessageResponseVO getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        RetryTaskLogMessage record;
        if (queryVO.getRetryTaskId() == null || StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            RetryTaskLogMessageResponseVO jobLogResponseVO = new RetryTaskLogMessageResponseVO();
            jobLogResponseVO.setNextStartId(0L);
            jobLogResponseVO.setFromIndex(0);
            return jobLogResponseVO;
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        PageDTO selectPage = (PageDTO)this.retryTaskLogMessageMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetryTaskLogMessage::getId, RetryTaskLogMessage::getLogNum}).ge(RetryTaskLogMessage::getId, (Object)queryVO.getStartId())).eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getRetryTaskId, (Object)queryVO.getRetryTaskId())).eq(RetryTaskLogMessage::getGroupName, (Object)queryVO.getGroupName())).orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime)).orderByDesc(CreateDt::getCreateDt));
        List records = selectPage.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new RetryTaskLogMessageResponseVO().setFinished(Boolean.TRUE).setNextStartId(queryVO.getStartId()).setFromIndex(0);
        }
        Integer fromIndex = Optional.ofNullable(queryVO.getFromIndex()).orElse(0);
        RetryTaskLogMessage firstRecord = (RetryTaskLogMessage)records.get(0);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{firstRecord.getId()});
        int total = firstRecord.getLogNum() - fromIndex;
        for (int i = 1; i < records.size() && total + (record = (RetryTaskLogMessage)records.get(i)).getLogNum() <= queryVO.getSize(); ++i) {
            total += record.getLogNum().intValue();
            ids.add(record.getId());
        }
        long nextStartId = 0L;
        List<Object> messages = Lists.newArrayList();
        List jobLogMessages = this.retryTaskLogMessageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getId, (Collection)ids)).orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime));
        for (RetryTaskLogMessage retryTaskLogMessage : jobLogMessages) {
            List originalList = (List)JsonUtil.parseObject((String)retryTaskLogMessage.getMessage(), List.class);
            int size = originalList.size() - fromIndex;
            List pageList = originalList.stream().skip(fromIndex.intValue()).limit(queryVO.getSize()).collect(Collectors.toList());
            if (messages.size() + size >= queryVO.getSize()) {
                messages.addAll(pageList);
                nextStartId = retryTaskLogMessage.getId();
                fromIndex = Math.min(fromIndex + queryVO.getSize(), originalList.size() - 1) + 1;
                break;
            }
            messages.addAll(pageList);
            nextStartId = retryTaskLogMessage.getId() + 1L;
            fromIndex = 0;
        }
        messages = messages.stream().sorted(Comparator.comparingLong(o -> Long.parseLong((String)o.get("time_stamp")))).collect(Collectors.toList());
        RetryTaskLogMessageResponseVO responseVO = new RetryTaskLogMessageResponseVO();
        responseVO.setMessage(messages);
        responseVO.setNextStartId(nextStartId);
        responseVO.setFromIndex(fromIndex);
        return responseVO;
    }

    @Override
    public RetryTaskResponseVO getRetryTaskById(Long id) {
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectById((Serializable)id);
        if (retryTask == null) {
            return null;
        }
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)retryTask.getRetryId());
        RetryTaskResponseVO responseVO = RetryTaskLogResponseVOConverter.INSTANCE.convert(retryTask);
        responseVO.setResponseVO(RetryTaskResponseVOConverter.INSTANCE.convert(retry));
        return responseVO;
    }

    @Override
    @Transactional
    public boolean deleteById(Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTask::getTaskStatus, (Collection)RetryTaskStatusEnum.TERMINAL_STATUS_SET)).eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getId, (Object)id));
        Assert.notNull((Object)retryTask, () -> new SnailJobServerException("\u6570\u636e\u5220\u9664\u5931\u8d25"));
        this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTask.getGroupName())).eq(RetryTaskLogMessage::getRetryTaskId, (Object)id));
        return 1 == this.retryTaskMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional
    public boolean batchDelete(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retryTasks = this.retryTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTask::getTaskStatus, (Collection)RetryTaskStatusEnum.TERMINAL_STATUS_SET)).eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(RetryTask::getId, ids));
        Assert.notEmpty((Iterable)retryTasks, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        Assert.isTrue((retryTasks.size() == ids.size() ? 1 : 0) != 0, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        for (RetryTask retryTask : retryTasks) {
            this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTask.getGroupName())).eq(RetryTaskLogMessage::getRetryTaskId, (Object)retryTask.getId()));
        }
        return 1 == this.retryTaskMapper.deleteByIds(ids);
    }

    @Override
    public Boolean stopById(Long id) {
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectById((Serializable)id);
        Assert.notNull((Object)retryTask, () -> new SnailJobServerException("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1"));
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)retryTask.getRetryId());
        Assert.notNull((Object)retry, () -> new SnailJobServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        TaskStopJobDTO taskStopJobDTO = RetryConverter.INSTANCE.toTaskStopJobDTO(retry);
        taskStopJobDTO.setOperationReason(Integer.valueOf(RetryOperationReasonEnum.MANNER_STOP.getReason()));
        taskStopJobDTO.setNeedUpdateTaskStatus(true);
        taskStopJobDTO.setMessage("\u7528\u6237\u624b\u52a8\u89e6\u53d1\u505c\u6b62");
        this.retryTaskStopHandler.stop(taskStopJobDTO);
        return true;
    }

    @Generated
    public RetryTaskServiceImpl(RetryTaskMapper retryTaskMapper, RetryMapper retryMapper, RetryTaskLogMessageMapper retryTaskLogMessageMapper, RetryTaskStopHandler retryTaskStopHandler) {
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
        this.retryTaskStopHandler = retryTaskStopHandler;
    }
}

