/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry-task"})
public class RetryTaskController {
    @Autowired
    private RetryTaskService retryTaskService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskPage(RetryTaskQueryVO queryVO) {
        return this.retryTaskService.getRetryTaskLogPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"/message/list"})
    public RetryTaskLogMessageResponseVO getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        return this.retryTaskService.getRetryTaskLogMessagePage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public RetryTaskResponseVO getRetryTaskById(@PathVariable(value="id") Long id) {
        return this.retryTaskService.getRetryTaskById(id);
    }

    @LoginRequired
    @PostMapping(value={"/stop/{id}"})
    public Boolean stopById(@PathVariable(value="id") Long id) {
        return this.retryTaskService.stopById(id);
    }

    @LoginRequired
    @DeleteMapping(value={"{id}"})
    public Boolean deleteById(@PathVariable(value="id") Long id) {
        return this.retryTaskService.deleteById(id);
    }

    @LoginRequired
    @DeleteMapping(value={"ids"})
    public Boolean batchDelete(@RequestBody @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") Set<Long> ids) {
        return this.retryTaskService.batchDelete(ids);
    }
}

