/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportNotifyRecipientVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientRequestVO;
import com.aizuda.snailjob.server.web.model.response.CommonLabelValueResponseVO;
import com.aizuda.snailjob.server.web.model.response.NotifyRecipientResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyRecipientService;
import com.aizuda.snailjob.server.web.service.convert.NotifyRecipientConverter;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class NotifyRecipientServiceImpl
implements NotifyRecipientService {
    private final NotifyRecipientMapper notifyRecipientMapper;
    private final GroupHandler groupHandler;

    @Override
    public PageResult<List<NotifyRecipientResponseVO>> getNotifyRecipientPageList(NotifyRecipientQueryVO queryVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        PageDTO notifyRecipientPageDTO = (PageDTO)this.notifyRecipientMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyRecipient::getNamespaceId, (Object)namespaceId)).eq(Objects.nonNull(queryVO.getNotifyType()), NotifyRecipient::getNotifyType, (Object)queryVO.getNotifyType())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getRecipientName()), NotifyRecipient::getRecipientName, (Object)queryVO.getRecipientName())).orderByDesc(CreateDt::getCreateDt));
        return new PageResult<List<NotifyRecipientResponseVO>>(pageDTO, NotifyRecipientConverter.INSTANCE.convertList(notifyRecipientPageDTO.getRecords()));
    }

    @Override
    public Boolean saveNotifyRecipient(NotifyRecipientRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyRecipient notifyRecipient = NotifyRecipientConverter.INSTANCE.convert(requestVO);
        notifyRecipient.setNamespaceId(namespaceId);
        notifyRecipient.setId(null);
        return 1 == this.notifyRecipientMapper.insert((Object)notifyRecipient);
    }

    @Override
    public Boolean updateNotifyRecipient(NotifyRecipientRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyRecipient notifyRecipient = NotifyRecipientConverter.INSTANCE.convert(requestVO);
        notifyRecipient.setNamespaceId(namespaceId);
        return 1 == this.notifyRecipientMapper.updateById((Object)notifyRecipient);
    }

    @Override
    public List<CommonLabelValueResponseVO> getNotifyRecipientList() {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List notifyRecipients = this.notifyRecipientMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{NotifyRecipient::getRecipientName, NotifyRecipient::getId}).eq(NotifyRecipient::getNamespaceId, (Object)namespaceId));
        return NotifyRecipientConverter.INSTANCE.convertListToCommonLabelValueList(notifyRecipients);
    }

    @Override
    public Boolean batchDeleteByIds(Set<Long> ids) {
        return ids.size() == this.notifyRecipientMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void importNotifyRecipient(List<NotifyRecipientRequestVO> notifyRecipientRequestVOS) {
        for (NotifyRecipientRequestVO notifyRecipientRequestVO : notifyRecipientRequestVOS) {
            this.saveNotifyRecipient(notifyRecipientRequestVO);
        }
    }

    @Override
    public String exportNotifyRecipient(ExportNotifyRecipientVO exportVO) {
        ArrayList requestList = new ArrayList();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PartitionTaskUtils.process(startId -> {
            List recipients = ((PageDTO)this.notifyRecipientMapper.selectPage((IPage)new PageDTO(0L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyRecipient::getNamespaceId, (Object)namespaceId)).eq(Objects.nonNull(exportVO.getNotifyType()), NotifyRecipient::getNotifyType, (Object)exportVO.getNotifyType())).likeRight(StrUtil.isNotBlank((CharSequence)exportVO.getRecipientName()), NotifyRecipient::getRecipientName, (Object)exportVO.getRecipientName())).ge(NotifyRecipient::getId, (Object)startId)).in(CollUtil.isNotEmpty(exportVO.getNotifyRecipientIds()), NotifyRecipient::getId, exportVO.getNotifyRecipientIds())).orderByAsc(NotifyRecipient::getId))).getRecords();
            return StreamUtils.toList((Collection)recipients, NotifyRecipientPartitionTask::new);
        }, partitionTasks -> {
            List partitionTaskList = partitionTasks;
            List<NotifyRecipientRequestVO> notifyRecipientRequestVOs = NotifyRecipientConverter.INSTANCE.toNotifyRecipientRequestVOs(StreamUtils.toList((Collection)partitionTaskList, NotifyRecipientPartitionTask::getRecipient));
            requestList.addAll(notifyRecipientRequestVOs);
        }, (long)0L);
        return JsonUtil.toJsonString(requestList);
    }

    @Generated
    public NotifyRecipientServiceImpl(NotifyRecipientMapper notifyRecipientMapper, GroupHandler groupHandler) {
        this.notifyRecipientMapper = notifyRecipientMapper;
        this.groupHandler = groupHandler;
    }

    private static class NotifyRecipientPartitionTask
    extends PartitionTask {
        private final NotifyRecipient recipient;

        public NotifyRecipientPartitionTask(@NotNull NotifyRecipient recipient) {
            this.recipient = recipient;
            this.setId(recipient.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotifyRecipientPartitionTask)) {
                return false;
            }
            NotifyRecipientPartitionTask other = (NotifyRecipientPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NotifyRecipient this$recipient = this.getRecipient();
            NotifyRecipient other$recipient = other.getRecipient();
            return !(this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NotifyRecipientPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            NotifyRecipient $recipient = this.getRecipient();
            result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
            return result;
        }

        @Generated
        public NotifyRecipient getRecipient() {
            return this.recipient;
        }
    }
}

