/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.handler;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.exception.AbstractError;
import com.aizuda.snailjob.common.core.exception.BaseSnailJobException;
import com.aizuda.snailjob.common.core.exception.SnailJobAuthenticationException;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.HandlerMethodValidationException;

@ControllerAdvice(basePackages={"com.aizuda.snailjob.server"})
@ResponseBody
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);
    public static final String DELIMITER_TO = "@";
    public static final String DELIMITER_COLON = ":";

    @ExceptionHandler(value={Exception.class})
    public Result onException(Exception ex) {
        log.error("\u5f02\u5e38\u7c7b onException,", (Throwable)ex);
        return new Result(0, "\u7cfb\u7edf\u5f02\u5e38");
    }

    @ExceptionHandler(value={BaseSnailJobException.class})
    public Result onBusinessException(BaseSnailJobException ex) {
        log.error("\u5f02\u5e38\u7c7b businessException", (Throwable)ex);
        if (ex instanceof SnailJobAuthenticationException) {
            SnailJobAuthenticationException authenticationException = (SnailJobAuthenticationException)ex;
            return new Result(authenticationException.getErrorCode().intValue(), ex.getMessage());
        }
        return new Result(0, ex.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result requestNotReadable(HttpMessageNotReadableException ex) {
        log.error("\u5f02\u5e38\u7c7b HttpMessageNotReadableException,", (Throwable)ex);
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result onConstraintViolationException(ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        if (CollUtil.isNotEmpty((Collection)constraintViolations)) {
            String errorMessage = StreamUtils.join((Collection)constraintViolations, ConstraintViolation::getMessage, (CharSequence)";");
            return new Result(0, errorMessage);
        }
        return new Result(0, e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result onMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        BindingResult result = e.getBindingResult();
        if (result != null && result.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            List errors = result.getFieldErrors();
            if (CollUtil.isNotEmpty((Collection)errors)) {
                FieldError error = (FieldError)errors.get(0);
                String rejectedValue = Objects.toString(error.getRejectedValue(), "");
                String defMsg = error.getDefaultMessage();
                if (rejectedValue.contains(DELIMITER_TO)) {
                    sb.append(defMsg);
                } else if (DELIMITER_COLON.contains(defMsg)) {
                    sb.append(error.getField()).append(" ").append(defMsg);
                } else {
                    sb.append(error.getField()).append(" ").append(defMsg).append(DELIMITER_COLON).append(rejectedValue);
                }
            } else {
                String msg = ((ObjectError)result.getAllErrors().get(0)).getDefaultMessage();
                sb.append(msg);
            }
            return new Result(0, sb.toString());
        }
        return null;
    }

    @ExceptionHandler(value={HandlerMethodValidationException.class})
    public Result onHandlerMethodValidationException(HandlerMethodValidationException e) {
        Object[] detailMessageArguments = e.getDetailMessageArguments();
        if (detailMessageArguments != null && detailMessageArguments.length > 0) {
            return new Result(0, detailMessageArguments[0].toString());
        }
        return new Result((Object)"\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    public Result requestTypeMismatch(TypeMismatchException ex) {
        log.error("\u5f02\u5e38\u7c7b TypeMismatchException {},", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result requestMissingServletRequest(MissingServletRequestParameterException ex) {
        log.error("\u5f02\u5e38\u7c7b MissingServletRequestParameterException {},", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Result request405() {
        log.error("\u5f02\u5e38\u7c7b HttpRequestMethodNotSupportedException ");
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result request415(HttpMediaTypeNotSupportedException ex) {
        log.error("\u5f02\u5e38\u7c7b HttpMediaTypeNotSupportedException {}", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }
}

