/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.model.enums;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.web.model.response.DashboardLineResponseVO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public enum DateTypeEnum {
    DAY(voList -> {
        Map responseVoMap = StreamUtils.toIdentityMap((Collection)voList, DashboardLineResponseVO::getCreateDt);
        int hourNow = LocalDateTime.now().getHour();
        for (int hourOffset = 0; hourOffset <= hourNow; ++hourOffset) {
            String createDt = LocalDateTime.now().plusHours(hourOffset).format(DateTimeFormatter.ofPattern("HH"));
            if (responseVoMap.containsKey(createDt)) continue;
            voList.add(DateTypeEnum.buildZeroedVoWithCreateDt(createDt));
        }
    }, startTime -> LocalDateTimeUtil.beginOfDay((LocalDateTime)startTime), endTime -> LocalDateTimeUtil.endOfDay((LocalDateTime)endTime)),
    WEEK(voList -> {
        Map responseVoMap = StreamUtils.toIdentityMap((Collection)voList, DashboardLineResponseVO::getCreateDt);
        for (int dayOffset = 0; dayOffset < 7; ++dayOffset) {
            String createDt = LocalDateTime.now().minusDays(dayOffset).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (responseVoMap.containsKey(createDt)) continue;
            voList.add(DateTypeEnum.buildZeroedVoWithCreateDt(createDt));
        }
    }, startTime -> LocalDateTimeUtil.beginOfDay((LocalDateTime)startTime).minusDays(7L), endTime -> LocalDateTimeUtil.endOfDay((LocalDateTime)endTime)),
    MONTH(voList -> {
        Map responseVoMap = StreamUtils.toIdentityMap((Collection)voList, DashboardLineResponseVO::getCreateDt);
        int lastDayOfMonth = LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
        for (int dayOffset = 0; dayOffset < lastDayOfMonth; ++dayOffset) {
            String createDt = LocalDate.now().minusDays(dayOffset).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (responseVoMap.containsKey(createDt)) continue;
            voList.add(DateTypeEnum.buildZeroedVoWithCreateDt(createDt));
        }
    }, startTime -> LocalDateTimeUtil.beginOfDay((LocalDateTime)startTime).minusMonths(1L), endTime -> LocalDateTimeUtil.endOfDay((LocalDateTime)endTime)),
    YEAR(voList -> {
        Map responseVoMap = StreamUtils.toIdentityMap((Collection)voList, DashboardLineResponseVO::getCreateDt);
        for (int monthOffset = 0; monthOffset < 12; ++monthOffset) {
            String createDt = LocalDateTime.now().minusMonths(monthOffset).format(DateTimeFormatter.ofPattern("yyyy-MM"));
            if (responseVoMap.containsKey(createDt)) continue;
            voList.add(DateTypeEnum.buildZeroedVoWithCreateDt(createDt));
        }
    }, startTime -> LocalDateTimeUtil.beginOfDay((LocalDateTime)LocalDateTime.now().with(TemporalAdjusters.firstDayOfYear())), endTime -> LocalDateTimeUtil.endOfDay((LocalDateTime)LocalDateTime.now().with(TemporalAdjusters.lastDayOfYear()))),
    OTHERS(voList -> {}, startTime -> LocalDateTimeUtil.beginOfDay((LocalDateTime)startTime), endTime -> LocalDateTimeUtil.endOfDay((LocalDateTime)endTime));

    private Consumer<List<DashboardLineResponseVO>> consumer;
    private Function<LocalDateTime, LocalDateTime> startTime;
    private Function<LocalDateTime, LocalDateTime> endTime;

    private static DashboardLineResponseVO buildZeroedVoWithCreateDt(String createDt) {
        return new DashboardLineResponseVO().setTotal(0L).setTotalNum(0L).setFail(0L).setFailNum(0L).setMaxCountNum(0L).setRunningNum(0L).setSuccess(0L).setSuccessNum(0L).setSuspendNum(0L).setStop(0L).setCancel(0L).setCreateDt(createDt);
    }

    private DateTypeEnum(Consumer<List<DashboardLineResponseVO>> consumer, Function<LocalDateTime, LocalDateTime> startTime, Function<LocalDateTime, LocalDateTime> endTime) {
        this.consumer = consumer;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Consumer<List<DashboardLineResponseVO>> getConsumer() {
        return this.consumer;
    }

    public Function<LocalDateTime, LocalDateTime> getStartTime() {
        return this.startTime;
    }

    public Function<LocalDateTime, LocalDateTime> getEndTime() {
        return this.endTime;
    }
}

