/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.core.writer;

import android.text.TextUtils;
import com.aiven.log.LogManager;
import com.aiven.log.core.IFullLinkQueueListener;
import com.aiven.log.core.writer.BaseWriter;
import com.aiven.log.mode.LogBean;
import com.aiven.log.util.LogFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;

public class PieWriter
extends BaseWriter
implements Runnable {
    private List<LogBean> beanList;
    private List<LogBean> nextList;
    private IFullLinkQueueListener mListener;
    private String tag;
    private Thread thread;

    public PieWriter(List<LogBean> list, IFullLinkQueueListener listener) {
        this.beanList = list;
        this.mListener = listener;
        this.tag = this.beanList.get(0).getTag();
        this.thread = new Thread(this);
    }

    public void setNextList(List<LogBean> list) {
        this.nextList = list;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public void initWriter() {
        if (!TextUtils.isEmpty((CharSequence)this.tag)) {
            File file = LogFileUtil.createFileIfNotExist(LogManager.getInstance().getRootPath() + File.separator + "sub" + File.separator + this.tag, this.getFileName());
            try {
                this.mWriter = new PrintWriter(new FileOutputStream(file, true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startWrite(LogBean log) {
        this.checkIsValid(log);
        if (this.mWriter == null) {
            return;
        }
        this.mWriter.println(log.toString());
    }

    public void over(boolean b) {
        if (b) {
            this.mWriter.flush();
        }
        if (this.mListener != null) {
            this.mListener.writeOver(this.tag);
        }
    }

    @Override
    public void run() {
        int i;
        boolean b = false;
        if (this.beanList != null && this.beanList.size() > 0) {
            b = true;
            for (i = 0; i < this.beanList.size(); ++i) {
                this.startWrite(this.beanList.get(i));
            }
            this.beanList = null;
        }
        if (this.nextList != null && this.nextList.size() > 0) {
            b = true;
            for (i = 0; i < this.nextList.size(); ++i) {
                this.startWrite(this.nextList.get(i));
            }
        }
        this.nextList = null;
        this.over(b);
    }

    public void execute() {
        this.thread.start();
    }
}

