/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log;

import android.app.Application;
import com.aiven.log.core.WholeCrashHandler;
import com.aiven.log.core.writer.BaseWriter;
import com.aiven.log.core.writer.CWriter;
import com.aiven.log.core.writer.CrashWriter;
import com.aiven.log.core.writer.ExceptionWriter;
import com.aiven.log.mode.LogBean;
import com.aiven.log.util.LogFileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class LogManager {
    public static final int CLOSE = 0;
    public static final int ONLY_PRINT_LOG = 1;
    public static final int PRINT_AND_SAVE = 2;
    public static final int ONLY_COLLECT_CRASH = 3;
    private static int switchState = 0;
    public static boolean printAble;
    public boolean subTag = false;
    private WholeCrashHandler crashHandler;
    private static LogManager mInstance;
    private LogLinkQueueIterator logLinkIterator;
    private ArrayBlockingQueue<LogBean> logQueue;
    private String rootPath;
    private Map<Integer, BaseWriter> mWriteMap = new HashMap<Integer, BaseWriter>();

    private LogManager() {
    }

    public static LogManager getInstance() {
        if (mInstance == null) {
            mInstance = new LogManager();
        }
        return mInstance;
    }

    public LogManager initLogManager(int state, String rootDirectoryPath) {
        switchState = state;
        this.rootPath = rootDirectoryPath;
        printAble = state != 0;
        if (state == 2 && this.logLinkIterator == null) {
            this.logLinkIterator = new LogLinkQueueIterator();
            this.logQueue = new ArrayBlockingQueue(30);
            this.logLinkIterator.start();
        }
        return this;
    }

    public LogManager openGlobalCrashHanler(Application application) {
        this.crashHandler = WholeCrashHandler.getInstance();
        this.crashHandler.init(application.getApplicationContext());
        return this;
    }

    public LogManager supportSubTag() {
        this.subTag = true;
        return this;
    }

    public int getState() {
        return switchState;
    }

    public void pushLog(LogBean bean) {
        if (bean.getType() == 3840) {
            this.writeCrash(bean);
            return;
        }
        if (bean != null && this.logQueue != null) {
            try {
                this.logQueue.put(bean);
            }
            catch (Exception e) {
                this.logQueue.clear();
            }
        }
    }

    private void writeCrash(LogBean bean) {
        if (switchState == 0 || switchState == 1) {
            return;
        }
        BaseWriter writer = this.mWriteMap.get(3840);
        if (writer == null) {
            writer = new CrashWriter();
            this.mWriteMap.put(3840, writer);
        }
        writer.startWrite(bean);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLog() {
        Map<Integer, BaseWriter> map = this.mWriteMap;
        synchronized (map) {
            File file = new File(this.getRootPath());
            LogFileUtil.deleteDirectory(file);
            this.mWriteMap.clear();
        }
    }

    private class LogLinkQueueIterator
    extends Thread {
        private LogLinkQueueIterator() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogBean bean = (LogBean)LogManager.this.logQueue.take();
                        BaseWriter writer = (BaseWriter)LogManager.this.mWriteMap.get(bean.getType());
                        if (bean.getType() == 61440) {
                            if (writer == null) {
                                writer = new ExceptionWriter();
                                LogManager.this.mWriteMap.put(bean.getType(), writer);
                            }
                        } else if (writer == null) {
                            writer = new CWriter();
                            LogManager.this.mWriteMap.put(bean.getType(), writer);
                        }
                        writer.startWrite(bean);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

