/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log;

import android.util.Log;
import com.aiven.log.LogManager;
import com.aiven.log.mode.LogBean;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logs {
    public static final int LOG_TYPE_COMMON = 257;
    public static final int LOG_TYPE_EXCEPTION = 514;
    public static final int LOG_TYPE_CRASH = 771;

    public static void logE(Exception e) {
        if (e == null) {
            return;
        }
        if (LogManager.printAble) {
            e.printStackTrace();
            if (LogManager.getInstance().getState() == 2) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                e.printStackTrace(printWriter);
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    cause.printStackTrace(printWriter);
                }
                printWriter.close();
                String result = ((Object)writer).toString();
                writer = null;
                LogManager.getInstance().pushLog(new LogBean("ERROR", result, 514));
            }
        }
    }

    public static void logError(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            Log.e((String)tag, (String)msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logI(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            Log.i((String)tag, (String)msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logV(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            Log.v((String)tag, (String)msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logW(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            Log.w((String)tag, (String)msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logD(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            Log.d((String)tag, (String)msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logPrint(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            System.out.println(tag + "  " + msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg));
            }
        }
    }

    public static void logPrint(String tag, Object msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            System.out.println(tag + "  " + msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean(tag, msg.toString()));
            }
        }
    }

    public static void logPrint(Object msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogManager.printAble) {
            System.out.println(msg);
            if (LogManager.getInstance().getState() == 2) {
                LogManager.getInstance().pushLog(new LogBean("", msg.toString()));
            }
        }
    }

    public static void clearLogFiles() {
        LogManager.getInstance().clearLog();
    }
}

