/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log;

import android.util.Log;
import com.aiven.log.LogConfig;
import com.aiven.log.action.LogRecodeUtils;
import com.aiven.log.model.LogMode;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logs {
    public static void logE(Exception e) {
        if (e == null) {
            return;
        }
        if (LogConfig.Debug) {
            e.printStackTrace();
            if (LogConfig.recodeAble) {
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                e.printStackTrace(printWriter);
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    cause.printStackTrace(printWriter);
                }
                printWriter.close();
                String result = ((Object)writer).toString();
                writer = null;
                LogRecodeUtils.getInstance().addLog(new LogMode("ERROR", result));
            }
        }
    }

    public static void logError(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.e((String)tag, (String)msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logI(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.i((String)tag, (String)msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logV(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.v((String)tag, (String)msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logW(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.w((String)tag, (String)msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logD(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.d((String)tag, (String)msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logPrint(String tag, String msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            System.out.println(tag + "  " + msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg));
            }
        }
    }

    public static void logPrint(String tag, Object msg) {
        if (tag == null) {
            tag = "--APPLOG--";
        }
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            System.out.println(tag + "  " + msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode(tag, msg.toString()));
            }
        }
    }

    public static void logPrint(Object msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            System.out.println("--APPLOG--  " + msg);
            if (LogConfig.recodeAble) {
                LogRecodeUtils.getInstance().addLog(new LogMode("--APPLOG--", msg.toString()));
            }
        }
    }

    public static void logCrash(String tag, String msg) {
        if (msg == null) {
            msg = "null";
        }
        if (LogConfig.Debug) {
            Log.e((String)"--APPLOG--", (String)msg);
            if (LogConfig.recodeAble) {
                LogMode md = new LogMode("--APPLOG--", msg.toString());
                md.setCrashInfo(true);
                LogRecodeUtils.getInstance().addLog(md);
            }
        }
    }

    public static void clearAllLogs() {
        File[] files;
        String filePath = LogConfig.getLogSavePath();
        File file = new File(filePath);
        if (file.exists() && file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            for (int j = 0; j < files.length; ++j) {
                files[j].delete();
            }
        }
    }
}

