/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.action;

import com.aiven.log.action.LogCheckListListener;
import com.aiven.log.action.LogWriteUtils;
import com.aiven.log.model.LogMode;
import java.util.concurrent.ArrayBlockingQueue;

public class LogRecodeUtils
implements LogCheckListListener {
    private static LogRecodeUtils mInstance;
    private ArrayBlockingQueue<LogMode> mLogsQueue = new ArrayBlockingQueue(30);
    private LogWriteUtils mWriteUtils;

    private LogRecodeUtils() {
    }

    public static LogRecodeUtils getInstance() {
        if (mInstance == null) {
            mInstance = new LogRecodeUtils();
            LogRecodeUtils.mInstance.mWriteUtils = new LogWriteUtils(mInstance);
            LogRecodeUtils.mInstance.mWriteUtils.startEngine();
        }
        return mInstance;
    }

    public void addLog(LogMode mode) {
        if (this.mLogsQueue == null) {
            this.mLogsQueue = new ArrayBlockingQueue(30);
        }
        this.mLogsQueue.add(mode);
        if (this.mWriteUtils == null) {
            this.mWriteUtils = new LogWriteUtils(this);
            this.mWriteUtils.startEngine();
        }
    }

    @Override
    public LogMode backNextLog() {
        if (this.mLogsQueue == null) {
            return null;
        }
        try {
            return this.mLogsQueue.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }
}

