/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.razorpay.R;
import com.razorpay.Checkout;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONObject;

@Payment(channel="razorpay")
public class Razorpay
implements IPayment {
    private static final String TAG = "Razorpay";
    private final WeakReference<Activity> mActivity;

    public Razorpay(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
        Checkout.preload((Context)application);
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String razorId = this.getParameter(params, "razorId");
        String razorpayKey = this.getParameter(params, "razorpayKey");
        int iconRes = 0;
        int labelRes = 0;
        try {
            Application context = activity.getApplication();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            iconRes = packageInfo.applicationInfo.icon;
            labelRes = packageInfo.applicationInfo.labelRes;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Checkout checkout = new Checkout();
        checkout.setKeyID(razorpayKey);
        checkout.setImage(iconRes);
        try {
            String themeColor = activity.getString(R.string.payment_razorpay_theme_color);
            JSONObject options = new JSONObject();
            options.put("name", (Object)activity.getString(labelRes));
            options.put("description", (Object)info.getPayName());
            options.put("order_id", (Object)razorId);
            options.put("amount", (Object)info.getPayMoney());
            options.put("currency", (Object)info.getCurrency());
            options.put("prefill.name", (Object)info.getName());
            options.put("prefill.email", (Object)info.getEmail());
            options.put("prefill.contact", (Object)info.getContact());
            options.put("theme.color", (Object)themeColor);
            checkout.open(activity, options);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error in starting Razorpay Checkout", (Throwable)e);
        }
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if ("0".equals(status)) {
            int code = this.getNumber(bundle.getString("code"));
            if (code == 0) {
                this.showToast(activity, R.string.payment_status_cancelled);
                return false;
            }
            if (code == 2) {
                this.showToast(activity, R.string.payment_network_error);
                return false;
            }
            if (code == 3) {
                this.showToast(activity, R.string.payment_invalid_options);
                return false;
            }
        }
        return true;
    }

    public void release() {
        if (this.mActivity.get() != null) {
            Checkout.clearUserData((Context)((Activity)this.mActivity.get()).getApplicationContext());
            this.mActivity.clear();
        }
    }

    private int getNumber(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            return -1;
        }
    }

    private void showToast(Activity activity, @StringRes int resId) {
        Toast.makeText((Context)activity, (int)resId, (int)0).show();
    }
}

