/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.razorpay.R;
import com.razorpay.Checkout;
import java.util.Map;
import org.json.JSONObject;

@Payment(channel="razorpay")
public class Razorpay
implements IPayment {
    public static final String TAG = "Razorpay";
    public Activity mActivity;

    public Razorpay(Activity activity) {
        this.mActivity = activity;
    }

    private int getNumber(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return -1;
    }

    private void showToast(@StringRes int n) {
        Toast.makeText((Context)this.mActivity, (int)n, (int)0).show();
    }

    public void callback(IPaymentCallback iPaymentCallback) {
    }

    public void preload(@NonNull Application application) {
        Checkout.preload((Context)application);
    }

    public void payment(@NonNull PaymentInfo paymentInfo, @NonNull Map<String, String> map) {
        JSONObject jSONObject;
        Checkout checkout;
        int n = 0;
        int n2 = 0;
        Application application = this.mActivity.getApplication();
        PackageInfo packageInfo = application.getPackageManager().getPackageInfo(application.getPackageName(), 0);
        PackageInfo packageInfo2 = packageInfo;
        n = packageInfo.applicationInfo.icon;
        try {
            n2 = packageInfo2.applicationInfo.labelRes;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        application = checkout;
        application();
        application.setKeyID(map.get("razorpayKey"));
        application.setImage(n);
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.mActivity.getString(n2));
        jSONObject.put("order_id", (Object)map.get("razorId"));
        jSONObject.put("currency", (Object)paymentInfo.getCurrency());
        jSONObject.put("amount", (Object)paymentInfo.getPayName());
        jSONObject.put("prefill.name", (Object)paymentInfo.getName());
        jSONObject.put("prefill.email", (Object)paymentInfo.getEmail());
        jSONObject.put("prefill.contact", (Object)paymentInfo.getContact());
        try {
            checkout.open(this.mActivity, jSONObject2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error in starting Razorpay Checkout", (Throwable)exception);
        }
    }

    public boolean isAvailable(@Nullable String string2, @NonNull Bundle bundle) {
        if ("0".equals(string2)) {
            int n = this.getNumber(bundle.getString("code"));
            if (n == 0) {
                this.showToast(R.string.payment_status_cancelled);
                return false;
            }
            if (n == 2) {
                this.showToast(R.string.payment_network_error);
                return false;
            }
            if (n == 3) {
                this.showToast(R.string.payment_invalid_options);
                return false;
            }
        }
        return true;
    }

    public void release() {
        Checkout.clearUserData((Context)this.mActivity.getApplicationContext());
    }
}

