/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import com.aitime.android.payment.paytm.R;
import com.paytm.pgsdk.PaytmOrder;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import com.paytm.pgsdk.TransactionManager;
import java.lang.ref.WeakReference;
import java.util.Map;

@Payment(channel="paytm")
public class Paytm
implements IPayment {
    private final WeakReference<Activity> mActivity;
    private IPaymentCallback mCallback;

    public Paytm(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public void callback(@NonNull IPaymentCallback callback) {
        this.mCallback = callback;
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        String orderId = this.getParameter(params, "orderId");
        String mid = this.getParameter(params, "mid");
        String txnToken = this.getParameter(params, "txnToken");
        String callbackUrl = this.getParameter(params, "callbackUrl");
        String showPaymentUrl = params.get("showPaymentUrl");
        String amount = info.getPayMoney();
        PaytmPaymentTransactionCallback transactionCallback = new PaytmPaymentTransactionCallback(){

            public void onTransactionResponse(Bundle bundle) {
                Paytm.this.mCallback.onPaymentResult("1", bundle);
            }

            public void networkNotAvailable() {
                Paytm.this.mCallback.onPaymentResult("-1", new Bundle());
            }

            public void onErrorProceed(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-2", bundle);
            }

            public void clientAuthenticationFailed(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-3", bundle);
            }

            public void someUIErrorOccurred(String s) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s);
                Paytm.this.mCallback.onPaymentResult("-4", bundle);
            }

            public void onErrorLoadingWebPage(int i, String s, String s1) {
                Bundle bundle = new Bundle();
                bundle.putString("message", s1);
                Paytm.this.mCallback.onPaymentResult("-5", bundle);
            }

            public void onBackPressedCancelTransaction() {
                Paytm.this.mCallback.onPaymentResult("0", new Bundle());
            }

            public void onTransactionCancel(String s, Bundle bundle) {
                Paytm.this.mCallback.onPaymentResult("0", bundle);
            }
        };
        PaytmOrder paytmOrder = new PaytmOrder(orderId, mid, txnToken, amount, callbackUrl);
        TransactionManager transactionManager = new TransactionManager(paytmOrder, transactionCallback);
        transactionManager.setAppInvokeEnabled(false);
        if (showPaymentUrl != null && showPaymentUrl.length() > 0) {
            transactionManager.setShowPaymentUrl(showPaymentUrl);
        }
        transactionManager.startTransaction(activity, 10004);
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if ("1".equals(status)) {
            return true;
        }
        if ("0".equals(status)) {
            this.showToast(activity, R.string.payment_status_cancelled);
            return false;
        }
        if ("-1".equals(status)) {
            this.showToast(activity, R.string.payment_network_error);
            return false;
        }
        String message = bundle.getString("message");
        if (message == null || message.length() == 0) {
            this.showToast(activity, R.string.payment_status_failed);
        } else {
            this.showToast(activity, activity.getString(R.string.payment_status_failed) + "[" + message + "]");
        }
        return false;
    }

    public void release() {
        this.mActivity.clear();
    }

    private void showToast(Activity activity, @StringRes int resId) {
        Toast.makeText((Context)activity, (int)resId, (int)0).show();
    }

    private void showToast(Activity activity, String text) {
        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
    }
}

