package com.aitime.android.payment;

import android.app.Activity;
import android.text.SpannableString;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;

/**
 * Offline dialog based on {@link AlertDialog}
 */
public class AlertOfflineDialog implements IOfflineDialog {

    @Override
    public void showDialog(@NonNull Activity activity, @NonNull String explain) {
        new AlertDialog.Builder(activity)
                .setMessage(new SpannableString(explain))
                .setPositiveButton(android.R.string.ok, null)
                .create()
                .show();
    }

}