package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.core.PayChannel;
import com.aitime.android.payment.entity.PaymentInfo;

import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Offline payment
 */
@Payment(channel = PayChannel.OFFLINE)
public class Offline implements IPayment {

    private Activity mActivity;

    private static Class<? extends IOfflineDialog> dialogClass = AlertOfflineDialog.class;

    public Offline(Activity activity) {
        this.mActivity = activity;
    }

    public static void setDialogClass(@NonNull Class<? extends IOfflineDialog> clazz) {
        Offline.dialogClass = clazz;
    }

    @Override
    public void callback(@NonNull IPaymentCallback callback) {

    }

    @Override
    public void preload(@NonNull Application application) {

    }

    /**
     * Initiate Payment
     *
     * @param info   payment information
     * @param params payment params(contains {@code explain}
     */
    @Override
    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        String explain = params.get("explain");
        if (explain == null || explain.length() == 0) {
            throw new IllegalArgumentException("The explain is required.");
        }
        try {
            dialogClass.newInstance().showDialog(mActivity, explain);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        return false;
    }

    @Override
    public void release() {

    }

}
