package com.aitime.android.payment.core;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.StringDef;

/**
 * Payment channel
 */
@StringDef({
        PayChannel.RAZORPAY,
        PayChannel.CASHFREE,
        PayChannel.PAYTM,
        PayChannel.SHAREIT,
        PayChannel.ADYEN,
        PayChannel.BRAINTREE,
        PayChannel.PAYSTACK,
        PayChannel.PAYUMONEY,
        PayChannel.PAYUMOBILE,
        PayChannel.MPESA,
        PayChannel.LINKURL,
        PayChannel.OFFLINE
})
@Retention(RetentionPolicy.SOURCE)
public @interface PayChannel {

    /**
     * Razorpay
     */
    String RAZORPAY = "razorpay";
    /**
     * Cashfree
     */
    String CASHFREE = "cashfree";
    /**
     * Shareit
     */
    String SHAREIT = "shareit";
    /**
     * Paytm
     */
    String PAYTM = "paytm";
    /**
     * Adyen
     */
    String ADYEN = "adyen";
    /**
     * Braintree
     */
    String BRAINTREE = "braintree";
    /**
     * Paystack
     */
    String PAYSTACK = "paystack";
    /**
     * PayUmoney
     */
    String PAYUMONEY = "payumoney";
    /**
     * PayUmobile
     */
    String PAYUMOBILE = "payumobile";
    /**
     * M-PESA
     */
    String MPESA = "mpesa";
    /**
     * LinkUrl
     */
    String LINKURL = "linkurl";
    /**
     * Offline
     */
    String OFFLINE = "offline";

}
