package com.aitime.android.payment.core;

import android.app.Application;
import android.os.Bundle;

import com.aitime.android.payment.entity.PaymentInfo;

import java.util.Map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Payment strategy interface
 */
public interface IPayment {

    /**
     * Attach Payment callback
     */
    void callback(@NonNull IPaymentCallback callback);

    /**
     * Preload payment resources
     */
    void preload(@NonNull Application application);

    /**
     * Initiate Payment
     */
    void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params);

    /**
     * Determine whether payment results are available
     */
    boolean isAvailable(@Nullable String status, @NonNull Bundle bundle);

    /**
     * Release payment resources
     */
    void release();

    /**
     * Return the parameter
     */
    default String getParameter(@NonNull Map<String, String> params, @NonNull String key) {
        String value = params.get(key);
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException(String.format("The %s is required.", key));
        }
        return value;
    }

}
