package com.aitime.android.payment.core;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * Payment channel
 */
@IntDef({
        PayCode.RAZORPAY,
        PayCode.CASHFREE,
        PayCode.PAYTM,
        PayCode.SHAREIT,
        PayCode.ADYEN,
        PayCode.BRAINTREE,
        PayCode.PAYSTACK,
        PayCode.MPESA,
        PayCode.OFFLINE
})
@Retention(RetentionPolicy.SOURCE)
public @interface PayCode {

    /**
     * Razorpay
     */
    int RAZORPAY = 10001;
    /**
     * Cashfree
     */
    int CASHFREE = 10002;
    /**
     * ShareitPay
     */
    int SHAREIT = 10003;
    /**
     * Paytm
     */
    int PAYTM = 10004;
    /**
     * Adyen
     */
    int ADYEN = 10005;
    /**
     * Braintree
     */
    int BRAINTREE = 10006;
    /**
     * Paystack
     */
    int PAYSTACK = 10007;
    /**
     * M-PESA
     */
    int MPESA = 10008;
    /**
     * Offline
     */
    int OFFLINE = 10000;

}
