/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.core.IPayment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;

public final class PaymentFactory {
    private static final String PACKAGE_PAYMENT = "com.aitime.android.payment";
    private Map<String, IPayment> payments = new ArrayMap();
    private Map<String, Class<? extends IPayment>> channels = new ArrayMap();
    private static volatile boolean hasRegister = false;

    public static PaymentFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private PaymentFactory() {
    }

    public void register(@NonNull Context context) {
        if (hasRegister) {
            return;
        }
        try {
            Context application = context.getApplicationContext();
            PackageManager packageManager = application.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(application.getPackageName(), 128);
            Bundle metaData = appInfo.metaData;
            if (metaData == null || metaData.isEmpty()) {
                return;
            }
            Set keySet = metaData.keySet();
            for (String key : keySet) {
                String className;
                Class<? extends IPayment> paymentClass;
                if (key == null || !key.startsWith(PACKAGE_PAYMENT) || (paymentClass = this.getPaymentClass(className = metaData.getString(key))) == null) continue;
                Payment annotation = paymentClass.getAnnotation(Payment.class);
                this.channels.put(annotation == null ? null : annotation.channel(), paymentClass);
            }
            hasRegister = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public IPayment create(@NonNull Activity activity, @NonNull String payChannel) {
        IPayment payment;
        if (!hasRegister) {
            this.register((Context)activity);
        }
        if ((payment = this.payments.get(payChannel)) != null) {
            return payment;
        }
        Class<? extends IPayment> paymentClass = this.channels.get(payChannel);
        if (paymentClass != null) {
            payment = this.generatePayment(activity, paymentClass);
            this.payments.put(payChannel, payment);
        }
        return payment;
    }

    public void clear() {
        if (this.payments != null && !this.payments.isEmpty()) {
            for (IPayment payment : this.payments.values()) {
                payment.release();
            }
            this.payments.clear();
        }
    }

    @Nullable
    private Class<? extends IPayment> getPaymentClass(String className) {
        try {
            Class<?> paymentClass = Class.forName(className);
            if (IPayment.class.isAssignableFrom(paymentClass)) {
                return paymentClass;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private IPayment generatePayment(@NonNull Activity activity, Class<? extends IPayment> clazz) {
        IPayment payment = null;
        try {
            payment = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            try {
                Constructor<? extends IPayment> constructor = clazz.getDeclaredConstructor(Activity.class);
                constructor.setAccessible(true);
                payment = constructor.newInstance(activity);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return payment;
    }

    private static class SingletonHolder {
        private static final PaymentFactory INSTANCE = new PaymentFactory();

        private SingletonHolder() {
        }
    }
}

