/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adyen.checkout.afterpay.AfterPayConfiguration;
import com.adyen.checkout.base.model.PaymentMethodsApiResponse;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.base.util.CheckoutCurrency;
import com.adyen.checkout.bcmc.BcmcConfiguration;
import com.adyen.checkout.card.CardConfiguration;
import com.adyen.checkout.core.api.Environment;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.log.Logger;
import com.adyen.checkout.dropin.DropIn;
import com.adyen.checkout.dropin.DropInConfiguration;
import com.adyen.checkout.googlepay.GooglePayConfiguration;
import com.aitime.android.payment.Payment;
import com.aitime.android.payment.adyen.AdyenStorage;
import com.aitime.android.payment.adyen.R;
import com.aitime.android.payment.adyen.SimpleDropInService;
import com.aitime.android.payment.core.IPayment;
import com.aitime.android.payment.core.IPaymentCallback;
import com.aitime.android.payment.entity.PaymentInfo;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Payment(channel="adyen")
public class Adyen
implements IPayment {
    private static final String TAG = "Adyen";
    private static Class<? extends SimpleDropInService> dropInServiceClass;
    private final WeakReference<Activity> mActivity;

    public Adyen(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
    }

    public static void setDropInServiceClass(Class<? extends SimpleDropInService> dropInServiceClass) {
        Adyen.dropInServiceClass = dropInServiceClass;
    }

    public void callback(@NonNull IPaymentCallback callback) {
    }

    public void preload(@NonNull Application application) {
    }

    public void payment(@NonNull PaymentInfo info, @NonNull Map<String, String> params) {
        Environment environment;
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return;
        }
        if (dropInServiceClass == null) {
            throw new IllegalArgumentException("The dropInServiceClass is required.");
        }
        String environmentName = this.getParameter(params, "environmentName");
        String publicKey = this.getParameter(params, "publicKey");
        String countryCode = this.getParameter(params, "countryCode");
        String merchantAccount = this.getParameter(params, "merchantAccount");
        String paymentMethods = this.getParameter(params, "paymentMethods");
        String shopperLocale = this.getParameter(params, "shopperLocale");
        if ("TEST".equalsIgnoreCase(environmentName)) {
            environment = Environment.TEST;
        } else if ("EUROPE".equalsIgnoreCase(environmentName)) {
            environment = Environment.EUROPE;
        } else if ("UNITED_STATES".equalsIgnoreCase(environmentName)) {
            environment = Environment.UNITED_STATES;
        } else if ("AUSTRALIA".equalsIgnoreCase(environmentName)) {
            environment = Environment.AUSTRALIA;
        } else {
            throw new IllegalArgumentException("The environment is not supported.");
        }
        AdyenStorage.setReference(info.getOrderId());
        AdyenStorage.setCountryCode(countryCode);
        AdyenStorage.setMerchantAccount(merchantAccount);
        AdyenStorage.setShopperReference(info.getPayName());
        String[] split = shopperLocale.split("_");
        Locale locale = new Locale(split[0], split[1]);
        GooglePayConfiguration googlePayConfig = new GooglePayConfiguration.Builder((Context)activity, merchantAccount).setCountryCode(countryCode).build();
        CardConfiguration cardConfiguration = new CardConfiguration.Builder((Context)activity, publicKey).setShopperReference(info.getPayName()).setShopperLocale(locale).build();
        AfterPayConfiguration afterPayConfiguration = new AfterPayConfiguration.Builder((Context)activity, AfterPayConfiguration.CountryCode.NL).setShopperLocale(locale).build();
        BcmcConfiguration bcmcConfiguration = new BcmcConfiguration.Builder((Context)activity, publicKey).setShopperLocale(locale).build();
        Intent resultIntent = new Intent((Context)activity, activity.getClass());
        resultIntent.setFlags(0x4000000);
        DropInConfiguration.Builder configurationBuilder = new DropInConfiguration.Builder((Context)activity, resultIntent, dropInServiceClass).setEnvironment(environment).setShopperLocale(locale).addCardConfiguration(cardConfiguration).addAfterPayConfiguration(afterPayConfiguration).addBcmcConfiguration(bcmcConfiguration).addGooglePayConfiguration(googlePayConfig);
        try {
            String currency = info.getCurrency();
            int value = Integer.parseInt(info.getPayMoney());
            CheckoutCurrency checkoutCurrency = CheckoutCurrency.find((String)currency);
            Amount amount = new Amount();
            amount.setValue(value * (int)Math.pow(10.0, checkoutCurrency.getFractionDigits()));
            amount.setCurrency(currency);
            AdyenStorage.setAmount(amount);
            configurationBuilder.setAmount(amount);
        }
        catch (CheckoutException e) {
            Logger.e((String)TAG, (String)"Amount $amount not valid", (Throwable)e);
        }
        try {
            PaymentMethodsApiResponse paymentMethodsApiResponse = (PaymentMethodsApiResponse)PaymentMethodsApiResponse.SERIALIZER.deserialize(new JSONObject(paymentMethods));
            DropIn.startPayment((Context)activity, (PaymentMethodsApiResponse)paymentMethodsApiResponse, (DropInConfiguration)configurationBuilder.build());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean isAvailable(@Nullable String status, @NonNull Bundle bundle) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
            return false;
        }
        if ("Refused".equalsIgnoreCase(status)) {
            this.showToast(activity, activity.getString(R.string.payment_status_failed));
            return false;
        }
        if ("Cancelled".equalsIgnoreCase(status)) {
            this.showToast(activity, activity.getString(R.string.payment_status_cancelled));
            return false;
        }
        if ("Error".equalsIgnoreCase(status)) {
            String refusalReason = bundle.getString("refusalReason");
            if (TextUtils.isEmpty((CharSequence)refusalReason)) {
                refusalReason = activity.getString(R.string.payment_status_failed);
            }
            this.showToast(activity, refusalReason);
            return false;
        }
        return "Authorised".equalsIgnoreCase(status) || "Received".equalsIgnoreCase(status);
    }

    public void release() {
        this.mActivity.clear();
        dropInServiceClass = null;
    }

    private void showToast(Activity activity, String message) {
        Toast.makeText((Context)activity, (CharSequence)message, (int)0).show();
    }
}

