package com.aitime.android.payment.adyen;

import android.os.Parcel;

import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;

import org.json.JSONException;
import org.json.JSONObject;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;

@Keep
final class AdditionalData extends ModelObject {

    private static final String ALLOW3DS2 = "allow3DS2";
    private static final String EXECUTETHREED = "executeThreeD";

    @NonNull
    public static final Creator<AdditionalData> CREATOR = new Creator<>(AdditionalData.class);

    @NonNull
    public static final Serializer<AdditionalData> SERIALIZER = new Serializer<AdditionalData>() {

        @NonNull
        @Override
        public JSONObject serialize(@NonNull AdditionalData modelObject) {
            final JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(ALLOW3DS2, modelObject.isAllow3DS2());
                jsonObject.putOpt(EXECUTETHREED, modelObject.isExecuteThreeD());
            } catch (JSONException e) {
                throw new ModelSerializationException(AdditionalData.class, e);
            }
            return jsonObject;
        }

        @NonNull
        @Override
        public AdditionalData deserialize(@NonNull JSONObject jsonObject) {
            final AdditionalData data = new AdditionalData();
            data.setAllow3DS2(jsonObject.optBoolean(ALLOW3DS2, true));
            data.setExecuteThreeD(jsonObject.optBoolean(EXECUTETHREED, false));
            return data;
        }
    };

    private boolean allow3DS2;
    private boolean executeThreeD;

    public boolean isAllow3DS2() {
        return allow3DS2;
    }

    public void setAllow3DS2(boolean allow3DS2) {
        this.allow3DS2 = allow3DS2;
    }

    public boolean isExecuteThreeD() {
        return executeThreeD;
    }

    public void setExecuteThreeD(boolean executeThreeD) {
        this.executeThreeD = executeThreeD;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        JsonUtils.writeToParcel(dest, SERIALIZER.serialize(this));
    }

}
