/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment.adyen;

import android.content.Context;
import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.redirect.RedirectComponent;
import com.aitime.android.payment.adyen.AdditionalData;
import org.json.JSONException;
import org.json.JSONObject;

public final class AdyenStorage {
    private static Amount amount;
    private static String reference;
    private static String countryCode;
    private static String shopperReference;
    private static String merchantAccount;
    private static boolean isThreeds2Enable;
    private static boolean isExecuteThreeD;

    public static void setAmount(Amount amount) {
        AdyenStorage.amount = amount;
    }

    public static void setCountryCode(String countryCode) {
        AdyenStorage.countryCode = countryCode;
    }

    public static void setReference(String reference) {
        AdyenStorage.reference = reference;
    }

    public static void setShopperReference(String shopperReference) {
        AdyenStorage.shopperReference = shopperReference;
    }

    public static void setMerchantAccount(String merchantAccount) {
        AdyenStorage.merchantAccount = merchantAccount;
    }

    public static void setThreeds2Enable(boolean isThreeds2Enable) {
        AdyenStorage.isThreeds2Enable = isThreeds2Enable;
    }

    public static void setExecuteThreeD(boolean isExecuteThreeD) {
        AdyenStorage.isExecuteThreeD = isExecuteThreeD;
    }

    public static JSONObject createPaymentRequest(Context context, JSONObject paymentComponentData) {
        JSONObject request = null;
        try {
            AdditionalData additionalData = new AdditionalData();
            additionalData.setAllow3DS2(isThreeds2Enable);
            additionalData.setExecuteThreeD(isExecuteThreeD);
            request = new JSONObject(paymentComponentData.toString());
            if (!request.has("amount")) {
                request.put("amount", (Object)Amount.SERIALIZER.serialize((ModelObject)amount));
            }
            if (!request.has("shopperReference")) {
                request.put("shopperReference", (Object)shopperReference);
            }
            if (!request.has("merchantAccount")) {
                request.put("merchantAccount", (Object)merchantAccount);
            }
            if (!request.has("reference")) {
                request.put("reference", (Object)reference);
            }
            if (!request.has("countryCode")) {
                request.put("countryCode", (Object)countryCode);
            }
            if (!request.has("channel")) {
                request.put("channel", (Object)"Android");
            }
            if (!request.has("returnUrl")) {
                request.put("returnUrl", (Object)RedirectComponent.getReturnUrl((Context)context));
            }
            if (!request.has("additionalData")) {
                request.put("additionalData", (Object)AdditionalData.SERIALIZER.serialize((ModelObject)additionalData));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return request;
    }

    public static void reset() {
        amount = null;
        countryCode = null;
        shopperReference = null;
        merchantAccount = null;
        isThreeds2Enable = true;
        isExecuteThreeD = false;
    }

    static {
        isThreeds2Enable = true;
        isExecuteThreeD = false;
    }
}

