/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment.adyen;

import android.content.Intent;
import android.os.Bundle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class AdyenResult {
    private static final String RESULT_CODE = "resultCode";
    private String resultCode;
    private Map<String, Object> results = new LinkedHashMap<String, Object>();

    public static AdyenResult create(Intent data) {
        AdyenResult result = new AdyenResult();
        String content = data.getStringExtra("payment_result");
        try {
            if (content != null && content.length() > 0) {
                JSONObject jsonObject = new JSONObject(content);
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    result.put(key, jsonObject.opt(key));
                }
                Object resultCode = result.results.get(RESULT_CODE);
                result.resultCode = resultCode == null ? null : resultCode.toString();
            }
        }
        catch (JSONException e) {
            result.resultCode = content;
        }
        return result;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    private void put(String key, Object value) {
        this.results.put(key, value);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(RESULT_CODE, this.resultCode);
        Set<Map.Entry<String, Object>> entrySet = this.results.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                bundle.putInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                bundle.putLong(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Short) {
                bundle.putShort(key, ((Short)value).shortValue());
                continue;
            }
            if (value instanceof Double) {
                bundle.putDouble(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                bundle.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof CharSequence) {
                bundle.putCharSequence(key, (CharSequence)value);
                continue;
            }
            bundle.putString(key, value.toString());
        }
        return bundle;
    }
}

