/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.payment.adyen;

import android.os.Parcel;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
final class AdditionalData
extends ModelObject {
    private static final String ALLOW3DS2 = "allow3DS2";
    private static final String EXECUTETHREED = "executeThreeD";
    @NonNull
    public static final ModelObject.Creator<AdditionalData> CREATOR = new ModelObject.Creator(AdditionalData.class);
    @NonNull
    public static final ModelObject.Serializer<AdditionalData> SERIALIZER = new ModelObject.Serializer<AdditionalData>(){

        @NonNull
        public JSONObject serialize(@NonNull AdditionalData modelObject) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(AdditionalData.ALLOW3DS2, (Object)modelObject.isAllow3DS2());
                jsonObject.putOpt(AdditionalData.EXECUTETHREED, (Object)modelObject.isExecuteThreeD());
            }
            catch (JSONException e) {
                throw new ModelSerializationException(AdditionalData.class, e);
            }
            return jsonObject;
        }

        @NonNull
        public AdditionalData deserialize(@NonNull JSONObject jsonObject) {
            AdditionalData data = new AdditionalData();
            data.setAllow3DS2(jsonObject.optBoolean(AdditionalData.ALLOW3DS2, true));
            data.setExecuteThreeD(jsonObject.optBoolean(AdditionalData.EXECUTETHREED, false));
            return data;
        }
    };
    private boolean allow3DS2;
    private boolean executeThreeD;

    AdditionalData() {
    }

    public boolean isAllow3DS2() {
        return this.allow3DS2;
    }

    public void setAllow3DS2(boolean allow3DS2) {
        this.allow3DS2 = allow3DS2;
    }

    public boolean isExecuteThreeD() {
        return this.executeThreeD;
    }

    public void setExecuteThreeD(boolean executeThreeD) {
        this.executeThreeD = executeThreeD;
    }

    public void writeToParcel(Parcel dest, int flags) {
        JsonUtils.writeToParcel((Parcel)dest, (JSONObject)SERIALIZER.serialize((ModelObject)this));
    }
}

