package com.aitime.android.payment.adyen;

import android.content.Context;

import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.redirect.RedirectComponent;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Adyen storage
 */
public final class AdyenStorage {

    private static Amount amount;
    private static String reference;
    private static String countryCode;
    private static String shopperReference;
    private static String merchantAccount;
    private static boolean isThreeds2Enable = true;
    private static boolean isExecuteThreeD = false;

    public static void setAmount(Amount amount) {
        AdyenStorage.amount = amount;
    }

    public static void setCountryCode(String countryCode) {
        AdyenStorage.countryCode = countryCode;
    }

    public static void setReference(String reference) {
        AdyenStorage.reference = reference;
    }

    public static void setShopperReference(String shopperReference) {
        AdyenStorage.shopperReference = shopperReference;
    }

    public static void setMerchantAccount(String merchantAccount) {
        AdyenStorage.merchantAccount = merchantAccount;
    }

    public static void setThreeds2Enable(boolean isThreeds2Enable) {
        AdyenStorage.isThreeds2Enable = isThreeds2Enable;
    }

    public static void setExecuteThreeD(boolean isExecuteThreeD) {
        AdyenStorage.isExecuteThreeD = isExecuteThreeD;
    }

    public static JSONObject createPaymentRequest(Context context, JSONObject paymentComponentData) {
        JSONObject request = null;
        try {
            AdditionalData additionalData = new AdditionalData();
            additionalData.setAllow3DS2(AdyenStorage.isThreeds2Enable);
            additionalData.setExecuteThreeD(AdyenStorage.isExecuteThreeD);
            request = new JSONObject(paymentComponentData.toString());
            if (!request.has("amount")) {
                request.put("amount", Amount.SERIALIZER.serialize(AdyenStorage.amount));
            }
            if (!request.has("shopperReference")) {
                request.put("shopperReference", AdyenStorage.shopperReference);
            }
            if (!request.has("merchantAccount")) {
                request.put("merchantAccount", AdyenStorage.merchantAccount);
            }
            if (!request.has("reference")) {
                request.put("reference", AdyenStorage.reference);
            }
            if (!request.has("countryCode")) {
                request.put("countryCode", AdyenStorage.countryCode);
            }
            if (!request.has("channel")) {
                request.put("channel", "Android");
            }
            if (!request.has("returnUrl")) {
                request.put("returnUrl", RedirectComponent.getReturnUrl(context));
            }
            if (!request.has("additionalData")) {
                request.put("additionalData", AdditionalData.SERIALIZER.serialize(additionalData));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return request;
    }

    public static void reset() {
        AdyenStorage.amount = null;
        AdyenStorage.countryCode = null;
        AdyenStorage.shopperReference = null;
        AdyenStorage.merchantAccount = null;
        AdyenStorage.isThreeds2Enable = true;
        AdyenStorage.isExecuteThreeD = false;
    }

}
