package com.aitime.android.payment.adyen;

import android.content.Intent;
import android.os.Bundle;

import com.adyen.checkout.dropin.DropIn;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * Adyen result
 */
public final class AdyenResult {

    private static final String RESULT_CODE = "resultCode";

    public static AdyenResult create(Intent data) {
        AdyenResult result = new AdyenResult();
        String content = data.getStringExtra(DropIn.RESULT_KEY);
        try {
            if (content != null && content.length() > 0) {
                JSONObject jsonObject = new JSONObject(content);
                Iterator<String> keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    result.put(key, jsonObject.opt(key));
                }
                Object resultCode = result.results.get(RESULT_CODE);
                result.resultCode = resultCode == null ? null : resultCode.toString();
            }
        } catch (JSONException e) {
            result.resultCode = content;
        }
        return result;
    }

    private String resultCode;
    private Map<String, Object> results = new LinkedHashMap<>();

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public Map<String, Object> getResults() {
        return results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    private void put(String key, Object value) {
        results.put(key, value);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(RESULT_CODE, resultCode);
        Set<Map.Entry<String, Object>> entrySet = results.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                bundle.putInt(key, (Integer) value);
            } else if (value instanceof Long) {
                bundle.putLong(key, (Long) value);
            } else if (value instanceof Short) {
                bundle.putShort(key, (Short) value);
            } else if (value instanceof Double) {
                bundle.putDouble(key, (Double) value);
            } else if (value instanceof Boolean) {
                bundle.putBoolean(key, (Boolean) value);
            } else if (value instanceof CharSequence) {
                bundle.putCharSequence(key, (CharSequence) value);
            } else {
                bundle.putString(key, value.toString());
            }
        }
        return bundle;
    }

}
