package com.aitime.android.payment.adyen;

import com.adyen.checkout.dropin.service.SimplifiedDropInService;

import org.json.JSONObject;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Base service to be extended by the merchant to provide the network calls that connect to the Adyen endpoints.
 * Calls should be made to your server, and from there to Adyen.
 */
public abstract class SimpleDropInService extends SimplifiedDropInService {

    @Override
    public JSONObject makePaymentsCallOrFail(@NonNull JSONObject paymentComponentData) {
        return makePaymentsCallOrFailure(AdyenStorage.createPaymentRequest(getApplication(), paymentComponentData));
    }

    @Override
    public JSONObject makeDetailsCallOrFail(@NonNull JSONObject actionComponentData) {
        return makeDetailsCallOrFailure(actionComponentData);
    }

    @Nullable
    protected abstract JSONObject makePaymentsCallOrFailure(@NonNull JSONObject paymentComponentData);

    @Nullable
    protected abstract JSONObject makeDetailsCallOrFailure(@NonNull JSONObject actionComponentData);

}
