package com.aitime.android.payment.adyen;

import android.content.Context;

import com.adyen.checkout.base.model.payments.Amount;
import com.adyen.checkout.redirect.RedirectComponent;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author liyunlong
 * @since 2020/4/21 19:16
 */
public final class AdyenStorage {

    private static Amount amount;
    private static String countryCode;
    private static String shopperReference;
    private static String merchantAccount;
    private static boolean isThreeds2Enable;
    private static boolean isExecuteThreeD;

    public static void setAmount(Amount amount) {
        AdyenStorage.amount = amount;
    }

    public static void setCountryCode(String countryCode) {
        AdyenStorage.countryCode = countryCode;
    }

    public static void setShopperReference(String shopperReference) {
        AdyenStorage.shopperReference = shopperReference;
    }

    public static void setMerchantAccount(String merchantAccount) {
        AdyenStorage.merchantAccount = merchantAccount;
    }

    public static void setIsThreeds2Enable(boolean isThreeds2Enable) {
        AdyenStorage.isThreeds2Enable = isThreeds2Enable;
    }

    public static void setIsExecuteThreeD(boolean isExecuteThreeD) {
        AdyenStorage.isExecuteThreeD = isExecuteThreeD;
    }

    public static JSONObject createPaymentRequest(Context context, JSONObject paymentComponentData) {
        JSONObject request = null;
        try {
            String packageName = context.getPackageName().replace(".", "_");
            AdditionalData additionalData = new AdditionalData();
            additionalData.setAllow3DS2(AdyenStorage.isThreeds2Enable);
            additionalData.setExecuteThreeD(AdyenStorage.isExecuteThreeD);
            request = new JSONObject(paymentComponentData.toString());
            request.put("amount", Amount.SERIALIZER.serialize(AdyenStorage.amount));
            request.put("shopperReference", AdyenStorage.shopperReference);
            request.put("merchantAccount", AdyenStorage.merchantAccount);
            request.put("countryCode", AdyenStorage.countryCode);
            request.put("channel", "Android");
            request.put("returnUrl", RedirectComponent.getReturnUrl(context));
            request.put("reference", packageName + "_" + System.currentTimeMillis());
            request.put("additionalData", AdditionalData.SERIALIZER.serialize(additionalData));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return request;
    }

    public static void reset() {
        AdyenStorage.amount = null;
        AdyenStorage.countryCode = null;
        AdyenStorage.shopperReference = null;
        AdyenStorage.merchantAccount = null;
        AdyenStorage.isThreeds2Enable = true;
        AdyenStorage.isExecuteThreeD = false;
    }

}
