package com.aitime.android.payment.adyen;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;

import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.model.JsonUtils;
import com.adyen.checkout.core.model.ModelObject;
import com.adyen.checkout.dropin.DropIn;

import org.json.JSONException;
import org.json.JSONObject;

import androidx.annotation.NonNull;

/**
 * Adyen result
 */
public final class AdyenResult extends ModelObject {

    private static final String RESULT_CODE = "resultCode";
    private static final String PSP_REFERENCE = "pspReference";
    private static final String REFUSAL_REASON = "refusalReason";

    @NonNull
    public static final Creator<AdyenResult> CREATOR = new Creator<>(AdyenResult.class);

    @NonNull
    public static final Serializer<AdyenResult> SERIALIZER = new Serializer<AdyenResult>() {

        @NonNull
        @Override
        public JSONObject serialize(@NonNull AdyenResult modelObject) {
            final JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.putOpt(RESULT_CODE, modelObject.getResultCode());
                jsonObject.putOpt(PSP_REFERENCE, modelObject.getPspReference());
                jsonObject.putOpt(REFUSAL_REASON, modelObject.getRefusalReason());
            } catch (JSONException e) {
                throw new ModelSerializationException(AdyenResult.class, e);
            }
            return jsonObject;
        }

        @NonNull
        @Override
        public AdyenResult deserialize(@NonNull JSONObject jsonObject) {
            final AdyenResult result = new AdyenResult();
            result.setResultCode(jsonObject.optString(RESULT_CODE));
            result.setPspReference(jsonObject.optString(PSP_REFERENCE));
            result.setRefusalReason(jsonObject.optString(REFUSAL_REASON));
            return result;
        }
    };

    public static AdyenResult create(Intent data) {
        try {
            String json = data.getStringExtra(DropIn.RESULT_KEY);
            if (json != null && json.length() > 0) {
                JSONObject jsonObject = new JSONObject(json);
                return SERIALIZER.deserialize(jsonObject);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new AdyenResult();
    }

    private String resultCode;
    private String pspReference;
    private String refusalReason;

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getPspReference() {
        return pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public String getRefusalReason() {
        return refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        JsonUtils.writeToParcel(dest, SERIALIZER.serialize(this));
    }

    public Bundle toBundle(){
        Bundle bundle = new Bundle();
        bundle.putString(RESULT_CODE, resultCode);
        bundle.putString(PSP_REFERENCE, pspReference);
        bundle.putString(REFUSAL_REASON, refusalReason);
        return bundle;
    }

}
