/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import com.aitime.android.ocr.camera.CameraThreadPool;
import com.aitime.android.ocr.camera.CameraView;
import com.aitime.android.ocr.camera.CropView;
import com.aitime.android.ocr.camera.FrameOverlayView;
import com.aitime.android.ocr.camera.MaskView;
import com.aitime.android.ocr.camera.OCRCameraLayout;
import com.aitime.android.ocr.camera.PermissionCallback;
import com.aitime.android.ocr.camera.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CameraActivity
extends Activity {
    public static final int REQUEST_CODE_PICK_IMAGE = 100;
    public static final int PERMISSIONS_REQUEST_CAMERA = 800;
    public static final int PERMISSIONS_EXTERNAL_STORAGE = 801;
    public Context context;
    public File outputFile;
    public int ocrType = 0;
    public Handler handler;
    public OCRCameraLayout takePictureContainer;
    public OCRCameraLayout cropContainer;
    public OCRCameraLayout confirmResultContainer;
    public ImageView lightButton;
    public CameraView cameraView;
    public ImageView displayImageView;
    public CropView cropView;
    public FrameOverlayView overlayView;
    public MaskView cropMaskView;
    public ImageView takePhotoBtn;
    public PermissionCallback permissionCallback;
    public View.OnClickListener albumButtonOnClickListener;
    public View.OnClickListener lightButtonOnClickListener;
    public View.OnClickListener takeButtonOnClickListener;
    public CameraView.OnTakePictureCallback autoTakePictureCallback;
    public CameraView.OnTakePictureCallback takePictureCallback;
    public View.OnClickListener cropCancelButtonListener;
    public View.OnClickListener cropConfirmButtonListener;
    public View.OnClickListener confirmButtonOnClickListener;
    public View.OnClickListener confirmCancelButtonOnClickListener;
    public View.OnClickListener rotateButtonOnClickListener;

    public CameraActivity() {
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        View.OnClickListener onClickListener3;
        View.OnClickListener onClickListener4;
        View.OnClickListener onClickListener5;
        CameraView.OnTakePictureCallback onTakePictureCallback;
        CameraView.OnTakePictureCallback onTakePictureCallback2;
        View.OnClickListener onClickListener6;
        View.OnClickListener onClickListener7;
        View.OnClickListener onClickListener8;
        PermissionCallback permissionCallback;
        Handler handler;
        Object object = handler;
        handler = new Handler();
        this.handler = object;
        object = permissionCallback;
        permissionCallback = new PermissionCallback(){

            @Override
            public boolean onRequestPermission() {
                ActivityCompat.requestPermissions((Activity)CameraActivity.this, (String[])new String[]{"android.permission.CAMERA"}, (int)800);
                return false;
            }
        };
        this.permissionCallback = object;
        object = onClickListener8;
        onClickListener8 = new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent;
                if (ActivityCompat.checkSelfPermission((Context)CameraActivity.this.getApplicationContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                    ActivityCompat.requestPermissions((Activity)CameraActivity.this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)801);
                    return;
                }
                2 v0 = this;
                view = intent;
                new Intent("android.intent.action.PICK").setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
                try {
                    v0.CameraActivity.this.startActivityForResult((Intent)view, 100);
                }
                catch (Exception exception) {
                    Toast.makeText((Context)CameraActivity.this.context, (int)R.string.not_installed_album, (int)0).show();
                }
            }
        };
        this.albumButtonOnClickListener = object;
        object = onClickListener7;
        onClickListener7 = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onClick(View view) {
                try {
                    if (CameraActivity.this.cameraView.getCameraControl().getFlashMode() == 0) {
                        CameraActivity.this.cameraView.getCameraControl().setFlashMode(1);
                    } else {
                        CameraActivity.this.cameraView.getCameraControl().setFlashMode(0);
                    }
                    CameraActivity.this.updateFlashMode();
                    return;
                }
                catch (Exception exception) {}
            }
        };
        this.lightButtonOnClickListener = object;
        object = onClickListener6;
        onClickListener6 = new View.OnClickListener(){

            public void onClick(View view) {
                CameraActivity.this.cameraView.takePicture(CameraActivity.this.outputFile, CameraActivity.this.takePictureCallback);
            }
        };
        this.takeButtonOnClickListener = object;
        object = onTakePictureCallback2;
        onTakePictureCallback2 = new CameraView.OnTakePictureCallback(){

            @Override
            public void onPictureTaken(final Bitmap bitmap) {
                CameraThreadPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        Intent intent;
                        FileOutputStream fileOutputStream;
                        Throwable throwable2;
                        block6: {
                            Intent intent2;
                            1 v9;
                            FileOutputStream fileOutputStream2;
                            1 v0 = this;
                            1 v1 = v0;
                            1 v2 = v0;
                            {
                                Intent intent3;
                                1 v5;
                                catch (Throwable throwable2) {
                                    break block6;
                                }
                                catch (IOException iOException) {}
                                {
                                    iOException.printStackTrace();
                                    v5 = this;
                                }
                                fileOutputStream = intent3;
                                fileOutputStream();
                                fileOutputStream.putExtra("ocrType", CameraActivity.this.ocrType);
                                intent3.putExtra("filePath", CameraActivity.this.outputFile.getAbsolutePath());
                                v5.CameraActivity.this.setResult(-1, (Intent)fileOutputStream);
                                v5.CameraActivity.this.finish();
                                return;
                            }
                            fileOutputStream = fileOutputStream2;
                            {
                                1 v8 = this;
                                v9 = v8;
                                fileOutputStream(CameraActivity.this.outputFile);
                                v8.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                            }
                            {
                                v9.bitmap.recycle();
                                fileOutputStream2.close();
                            }
                            fileOutputStream = intent2;
                            fileOutputStream();
                            fileOutputStream.putExtra("ocrType", CameraActivity.this.ocrType);
                            intent2.putExtra("filePath", CameraActivity.this.outputFile.getAbsolutePath());
                            v1.CameraActivity.this.setResult(-1, (Intent)fileOutputStream);
                            v2.CameraActivity.this.finish();
                            return;
                        }
                        1 v11 = this;
                        fileOutputStream = intent;
                        fileOutputStream();
                        fileOutputStream.putExtra("ocrType", CameraActivity.this.ocrType);
                        intent.putExtra("filePath", CameraActivity.this.outputFile.getAbsolutePath());
                        v11.CameraActivity.this.setResult(-1, (Intent)fileOutputStream);
                        v11.CameraActivity.this.finish();
                        throw throwable2;
                    }
                });
            }
        };
        this.autoTakePictureCallback = object;
        object = onTakePictureCallback;
        onTakePictureCallback = new CameraView.OnTakePictureCallback(){

            @Override
            public void onPictureTaken(final Bitmap bitmap) {
                CameraActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        1 v0 = this;
                        v0.CameraActivity.this.takePictureContainer.setVisibility(4);
                        if (v0.CameraActivity.this.cropMaskView.getOcrType() == 0) {
                            1 v1 = this;
                            v1.CameraActivity.this.cropView.setFilePath(CameraActivity.this.outputFile.getAbsolutePath());
                            v1.CameraActivity.this.showCrop();
                        } else if (CameraActivity.this.cropMaskView.getOcrType() == 1) {
                            1 v2 = this;
                            v2.CameraActivity.this.cropView.setFilePath(CameraActivity.this.outputFile.getAbsolutePath());
                            v2.CameraActivity.this.cropMaskView.setVisibility(4);
                            v2.CameraActivity.this.overlayView.setVisibility(0);
                            v2.CameraActivity.this.overlayView.setTypeWide();
                            v2.CameraActivity.this.showCrop();
                        } else {
                            1 v3 = this;
                            v3.CameraActivity.this.displayImageView.setImageBitmap(bitmap);
                            v3.CameraActivity.this.showResultConfirm();
                        }
                    }
                });
            }
        };
        this.takePictureCallback = object;
        object = onClickListener5;
        onClickListener5 = new View.OnClickListener(){

            public void onClick(View view) {
                7 v0 = this;
                v0.CameraActivity.this.cropView.setFilePath(null);
                v0.CameraActivity.this.showTakePicture();
            }
        };
        this.cropCancelButtonListener = object;
        object = onClickListener4;
        onClickListener4 = new View.OnClickListener(){

            public void onClick(View view) {
                int n = this_.CameraActivity.this.cropMaskView.getOcrType();
                Rect rect = n != 1 && n != 11 && n != 12 && n != 21 && n != 22 && n != 31 && n != 32 && n != 41 && n != 42 ? this_.CameraActivity.this.overlayView.getFrameRect() : this_.CameraActivity.this.cropMaskView.getFrameRect();
                8 v0 = this_;
                8 this_ = v0.CameraActivity.this.cropView.crop(rect);
                v0.CameraActivity.this.displayImageView.setImageBitmap((Bitmap)this_);
                v0.CameraActivity.this.cropAndConfirm();
            }
        };
        this.cropConfirmButtonListener = object;
        object = onClickListener3;
        onClickListener3 = new View.OnClickListener(){

            public void onClick(View view) {
                CameraActivity.this.doConfirmResult();
            }
        };
        this.confirmButtonOnClickListener = object;
        object = onClickListener2;
        onClickListener2 = new View.OnClickListener(){

            public void onClick(View view) {
                11 v0 = this;
                v0.CameraActivity.this.displayImageView.setImageBitmap(null);
                v0.CameraActivity.this.showTakePicture();
            }
        };
        this.confirmCancelButtonOnClickListener = object;
        object = onClickListener;
        onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                CameraActivity.this.cropView.rotate(90);
            }
        };
        this.rotateButtonOnClickListener = object;
    }

    public static Intent getIntent(Context context, int n) {
        return CameraActivity.getIntent(context, n, null);
    }

    public static Intent getIntent(Context context, int n, String string2) {
        Intent intent = new Intent(context, CameraActivity.class);
        intent.putExtra("ocrType", n);
        intent.putExtra("filePath", string2);
        return intent;
    }

    private void initParams() {
        int n;
        String string2 = this.getIntent().getStringExtra("filePath");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            File file;
            File file2 = file;
            file = new File(string2);
            this.outputFile = file2;
        } else {
            this.outputFile = new File(this.getFilesDir(), "ocr_" + System.currentTimeMillis() + ".jpg");
        }
        this.ocrType = n = this.getIntent().getIntExtra("ocrType", 0);
        if (n != 1 && n != 11 && n != 12 && n != 21 && n != 22 && n != 31 && n != 32 && n != 41 && n != 42) {
            this.cropMaskView.setVisibility(4);
        } else {
            this.overlayView.setVisibility(4);
        }
        CameraActivity cameraActivity = this;
        cameraActivity.cameraView.setEnableScan(false);
        cameraActivity.cameraView.setOCRType(this.ocrType);
        cameraActivity.cropMaskView.setOCRType(this.ocrType);
    }

    private void showTakePicture() {
        CameraActivity cameraActivity = this;
        cameraActivity.cameraView.getCameraControl().resume();
        cameraActivity.updateFlashMode();
        cameraActivity.takePictureContainer.setVisibility(0);
        cameraActivity.confirmResultContainer.setVisibility(4);
        cameraActivity.cropContainer.setVisibility(4);
    }

    private void showCrop() {
        CameraActivity cameraActivity = this;
        cameraActivity.cameraView.getCameraControl().pause();
        cameraActivity.updateFlashMode();
        cameraActivity.takePictureContainer.setVisibility(4);
        cameraActivity.confirmResultContainer.setVisibility(4);
        cameraActivity.cropContainer.setVisibility(0);
    }

    private void showResultConfirm() {
        CameraActivity cameraActivity = this;
        cameraActivity.cameraView.getCameraControl().pause();
        cameraActivity.updateFlashMode();
        cameraActivity.takePictureContainer.setVisibility(4);
        cameraActivity.confirmResultContainer.setVisibility(0);
        cameraActivity.cropContainer.setVisibility(4);
    }

    private void updateFlashMode() {
        if (this.cameraView.getCameraControl().getFlashMode() == 1) {
            this.lightButton.setImageResource(R.drawable.ic_ocr_light_on);
        } else {
            this.lightButton.setImageResource(R.drawable.ic_ocr_light_off);
        }
    }

    private void cropAndConfirm() {
        CameraActivity cameraActivity = this;
        cameraActivity.cameraView.getCameraControl().pause();
        cameraActivity.updateFlashMode();
        cameraActivity.doConfirmResult();
    }

    private void doConfirmResult() {
        CameraThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                Intent intent;
                FileOutputStream fileOutputStream;
                FileOutputStream fileOutputStream2 = fileOutputStream;
                fileOutputStream2(CameraActivity.this.outputFile);
                ((BitmapDrawable)CameraActivity.this.displayImageView.getDrawable()).getBitmap().compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream2);
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                9 v2 = this;
                fileOutputStream2 = intent;
                fileOutputStream2();
                fileOutputStream2.putExtra("ocrType", CameraActivity.this.ocrType);
                intent.putExtra("filePath", CameraActivity.this.outputFile.getAbsolutePath());
                v2.CameraActivity.this.setResult(-1, (Intent)fileOutputStream2);
                v2.CameraActivity.this.finish();
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private String getRealPathFromURI(Uri var1_1) {
        block14: {
            block13: {
                v0 = this /* !! */ ;
                this /* !! */  = null;
                var2_3 = v0.getContentResolver().query(var1_1, null, null, null, null);
                if (var2_3 != null) break block13;
                v1 = var1_1.getPath();
lbl8:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v2 = var2_3;
            v3 = v2;
            v4 = v2;
            v2.moveToFirst();
            v1 = v3.getString(v4.getColumnIndex("_data"));
            ** continue;
            this /* !! */  = v1;
            if (var2_3 == null) break block14;
            var2_3.close();
            catch (Throwable var1_2) {
                try {
                    throw var1_2;
                }
                catch (Throwable var3_4) {
                    if (var2_3 == null) ** GOTO lbl36
                    try {
                        var2_3.close();
                        ** GOTO lbl36
                    }
                    catch (Throwable v5) {
                        try {
                            var1_2.addSuppressed(v5);
lbl36:
                            // 3 sources

                            throw var3_4;
                        }
                        catch (Throwable v6) {
                            v6.printStackTrace();
                        }
                    }
                }
            }
        }
        return this /* !! */ ;
    }

    private void setOrientation(Configuration configuration) {
        int n = this.getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        int n3 = configuration.orientation;
        if (n3 != 1) {
            if (n3 != 2) {
                n = OCRCameraLayout.ORIENTATION_PORTRAIT;
                this.cameraView.setOrientation(0);
                int n4 = n;
                n = n2;
                n2 = n4;
            } else {
                n2 = OCRCameraLayout.ORIENTATION_HORIZONTAL;
                n = n != 0 && n != 1 ? 270 : 90;
            }
        } else {
            n = 0;
            n2 = OCRCameraLayout.ORIENTATION_PORTRAIT;
        }
        CameraActivity cameraActivity = this;
        cameraActivity.takePictureContainer.setOrientation(n2);
        cameraActivity.cameraView.setOrientation(n);
        cameraActivity.cropContainer.setOrientation(n2);
        cameraActivity.confirmResultContainer.setOrientation(n2);
    }

    private void doClear() {
        CameraThreadPool.cancelAutoFocusTimer();
    }

    public void onCreate(Bundle object) {
        this.context = this;
        CameraActivity cameraActivity = this.context;
        super.onCreate((Bundle)object);
        cameraActivity.setContentView(R.layout.activity_camera_ocr);
        cameraActivity.takePictureContainer = (OCRCameraLayout)cameraActivity.findViewById(R.id.take_picture_container);
        cameraActivity.confirmResultContainer = (OCRCameraLayout)cameraActivity.findViewById(R.id.confirm_result_container);
        object = (CameraView)cameraActivity.findViewById(R.id.camera_view);
        cameraActivity.cameraView = object;
        ((CameraView)((Object)object)).getCameraControl().setPermissionCallback(this.permissionCallback);
        object = (ImageView)cameraActivity.findViewById(R.id.light_button);
        this.lightButton = object;
        object.setOnClickListener(this.lightButtonOnClickListener);
        cameraActivity.takePhotoBtn = (ImageView)cameraActivity.findViewById(R.id.take_photo_button);
        cameraActivity.findViewById(R.id.album_button).setOnClickListener(this.albumButtonOnClickListener);
        cameraActivity.takePhotoBtn.setOnClickListener(this.takeButtonOnClickListener);
        cameraActivity.displayImageView = (ImageView)cameraActivity.findViewById(R.id.display_image_view);
        cameraActivity.confirmResultContainer.findViewById(R.id.confirm_button).setOnClickListener(this.confirmButtonOnClickListener);
        cameraActivity.confirmResultContainer.findViewById(R.id.cancel_button).setOnClickListener(this.confirmCancelButtonOnClickListener);
        cameraActivity.findViewById(R.id.rotate_button).setOnClickListener(this.rotateButtonOnClickListener);
        cameraActivity.cropView = (CropView)cameraActivity.findViewById(R.id.crop_view);
        cameraActivity.cropContainer = (OCRCameraLayout)cameraActivity.findViewById(R.id.crop_container);
        cameraActivity.overlayView = (FrameOverlayView)cameraActivity.findViewById(R.id.overlay_view);
        cameraActivity.cropContainer.findViewById(R.id.confirm_button).setOnClickListener(this.cropConfirmButtonListener);
        cameraActivity.cropMaskView = (MaskView)cameraActivity.cropContainer.findViewById(R.id.crop_mask_view);
        cameraActivity.cropContainer.findViewById(R.id.cancel_button).setOnClickListener(this.cropCancelButtonListener);
        cameraActivity.setOrientation(cameraActivity.getResources().getConfiguration());
        cameraActivity.initParams();
        cameraActivity.cameraView.setAutoPictureCallback(this.autoTakePictureCallback);
    }

    public void onPause() {
        CameraActivity cameraActivity = this;
        super.onPause();
        cameraActivity.cameraView.stop();
    }

    public void onResume() {
        CameraActivity cameraActivity = this;
        super.onResume();
        cameraActivity.cameraView.start();
    }

    public void onConfigurationChanged(@NonNull Configuration configuration) {
        CameraActivity cameraActivity = this;
        super.onConfigurationChanged(configuration);
        cameraActivity.setOrientation(configuration);
    }

    /*
     * Unable to fully structure code
     */
    public void onActivityResult(int var1_1, int var2_3, Intent var3_4) {
        block3: {
            super.onActivityResult(var1_1, var2_3, var3_4);
            if (var1_1 != 100) break block3;
            if (var2_3 != -1) ** GOTO lbl14
            try {
                v0 = this;
                v1 = v0;
                v2 = v0;
                var1_2 = var3_4.getData();
            }
            catch (Throwable v3) {}
            v1.cropView.setFilePath(this.getRealPathFromURI(var1_2));
            v2.showCrop();
            break block3;
lbl14:
            // 1 sources

            this.cameraView.getCameraControl().resume();
        }
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        if (n == 800) {
            if (nArray.length > 0 && nArray[0] == 0) {
                this.cameraView.getCameraControl().refreshPermission();
            } else {
                Toast.makeText((Context)this.context, (int)R.string.camera_permission_required, (int)1).show();
            }
        }
    }

    public void onDestroy() {
        CameraActivity cameraActivity = this;
        super.onDestroy();
        cameraActivity.doClear();
    }
}

