/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.aitime.android.ocr.camera.CameraView;
import com.aitime.android.ocr.camera.ICameraControl;
import com.aitime.android.ocr.camera.PermissionCallback;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public class Camera2Control
implements ICameraControl {
    public static final SparseIntArray ORIENTATIONS;
    public static final int STATE_PREVIEW = 0;
    public static final int STATE_WAITING_FOR_LOCK = 1;
    public static final int STATE_WAITING_FOR_CAPTURE = 2;
    public static final int STATE_CAPTURING = 3;
    public static final int STATE_PICTURE_TAKEN = 4;
    public static final int MAX_PREVIEW_WIDTH = 1920;
    public static final int MAX_PREVIEW_HEIGHT = 1080;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public int flashMode;
    public int orientation = 0;
    public int state = 0;
    public Context context;
    public ICameraControl.OnTakePictureCallback onTakePictureCallback;
    public PermissionCallback permissionCallback;
    public String cameraId;
    public TextureView textureView;
    public Size previewSize;
    public Rect previewFrame;
    public HandlerThread backgroundThread;
    public Handler backgroundHandler;
    public ImageReader imageReader;
    public CameraCaptureSession captureSession;
    public CameraDevice cameraDevice;
    public CaptureRequest.Builder previewRequestBuilder;
    public CaptureRequest previewRequest;
    public Semaphore cameraLock;
    public int sensorOrientation;
    public final TextureView.SurfaceTextureListener surfaceTextureListener;
    public final CameraDevice.StateCallback deviceStateCallback;
    public final ImageReader.OnImageAvailableListener onImageAvailableListener;
    public CameraCaptureSession.CaptureCallback captureCallback;
    public Comparator<Size> sizeComparator;

    public Camera2Control(Context context) {
        TextureView textureView;
        Comparator<Size> comparator;
        CameraCaptureSession.CaptureCallback captureCallback;
        ImageReader.OnImageAvailableListener onImageAvailableListener;
        CameraDevice.StateCallback stateCallback;
        TextureView.SurfaceTextureListener surfaceTextureListener;
        Semaphore semaphore;
        Rect rect;
        Object object = rect;
        rect = new Rect();
        camera2Control.previewFrame = object;
        object = semaphore;
        semaphore = new Semaphore(1);
        camera2Control.cameraLock = object;
        object = surfaceTextureListener;
        surfaceTextureListener = new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
                Camera2Control.this.openCamera(n, n2);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
                Camera2Control.this.configureTransform(n, n2);
                ((Camera2Control)Camera2Control.this).previewFrame.left = 0;
                ((Camera2Control)Camera2Control.this).previewFrame.top = 0;
                ((Camera2Control)Camera2Control.this).previewFrame.right = n;
                ((Camera2Control)Camera2Control.this).previewFrame.bottom = n2;
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                Camera2Control.this.stop();
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        };
        camera2Control.surfaceTextureListener = object;
        object = stateCallback;
        stateCallback = new CameraDevice.StateCallback(){

            public void onOpened(@NonNull CameraDevice cameraDevice) {
                2 v0 = this;
                v0.Camera2Control.this.cameraLock.release();
                Camera2Control.access$402(v0.Camera2Control.this, cameraDevice);
                v0.Camera2Control.this.createCameraPreviewSession();
            }

            public void onDisconnected(@NonNull CameraDevice cameraDevice) {
                Camera2Control.this.cameraLock.release();
                cameraDevice.close();
                Camera2Control.access$402(Camera2Control.this, null);
            }

            public void onError(@NonNull CameraDevice cameraDevice, int n) {
                Camera2Control.this.cameraLock.release();
                cameraDevice.close();
                Camera2Control.access$402(Camera2Control.this, null);
            }
        };
        camera2Control.deviceStateCallback = object;
        object = onImageAvailableListener;
        onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader imageReader) {
                if (object.Camera2Control.this.onTakePictureCallback != null) {
                    4 v0 = object;
                    Image image = imageReader.acquireNextImage();
                    ByteBuffer byteBuffer = image.getPlanes()[0].getBuffer();
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    Object object = byArray;
                    byteBuffer.get(byArray);
                    image.close();
                    v0.Camera2Control.this.onTakePictureCallback.onPictureTaken((byte[])object);
                }
            }
        };
        camera2Control.onImageAvailableListener = object;
        object = captureCallback;
        captureCallback = new CameraCaptureSession.CaptureCallback(){

            /*
             * Enabled aggressive block sorting
             */
            private void process(CaptureResult object) {
                block8: {
                    block9: {
                        int n = Camera2Control.this.state;
                        if (n == 1) break block9;
                        if (n != 2) {
                            if (n != 3) {
                                return;
                            }
                            if ((object = (Integer)object.get(CaptureResult.CONTROL_AE_STATE)) != null) {
                                if ((Integer)object == 5) return;
                            }
                            break block8;
                        } else if ((object = (Integer)object.get(CaptureResult.CONTROL_AE_STATE)) != null && (Integer)object != 5 && (Integer)object != 4) {
                            if ((Integer)object != 2) return;
                            break block8;
                        } else {
                            Camera2Control.access$1202(Camera2Control.this, 3);
                            return;
                        }
                    }
                    Integer n = (Integer)object.get(CaptureResult.CONTROL_AF_STATE);
                    if (n == null) {
                        Camera2Control.this.captureStillPicture();
                        return;
                    }
                    int n2 = n;
                    if ((n2 == 2 || n2 == 4 || n2 == 5) && (object = (Integer)object.get(CaptureResult.CONTROL_AE_STATE)) != null && (Integer)object != 2) {
                        Camera2Control.this.runPreCaptureSequence();
                        return;
                    }
                }
                Camera2Control.this.captureStillPicture();
            }

            public void onCaptureProgressed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureResult captureResult) {
                this.process(captureResult);
            }

            public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
                this.process((CaptureResult)totalCaptureResult);
            }
        };
        camera2Control.captureCallback = object;
        object = comparator;
        comparator = new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                return Long.signum((long)size.getWidth() * (long)size.getHeight() - (long)size2.getWidth() * (long)size2.getHeight());
            }
        };
        camera2Control.sizeComparator = object;
        camera2Control.context = context;
        Camera2Control camera2Control = textureView;
        textureView = new TextureView(context);
        v8.textureView = camera2Control;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openCamera(int n, int n2) {
        if (ContextCompat.checkSelfPermission((Context)((Camera2Control)((Object)string2)).context, (String)"android.permission.CAMERA") != 0) {
            ((Camera2Control)((Object)string2)).requestCameraPermission();
            return;
        }
        Camera2Control camera2Control = string2;
        ((Camera2Control)((Object)string2)).setUpCameraOutputs(n, n2);
        camera2Control.configureTransform(n, n2);
        CameraManager cameraManager = (CameraManager)camera2Control.context.getSystemService("camera");
        Semaphore semaphore = camera2Control.cameraLock;
        if (!semaphore.tryAcquire(2500L, TimeUnit.MILLISECONDS)) throw new RuntimeException("Time out waiting to lock camera opening.");
        CameraManager cameraManager2 = cameraManager;
        Camera2Control camera2Control2 = string2;
        Camera2Control camera2Control3 = camera2Control2;
        Camera2Control camera2Control4 = camera2Control2;
        String string2 = camera2Control2.cameraId;
        cameraManager = camera2Control4.deviceStateCallback;
        Handler handler = camera2Control3.backgroundHandler;
        try {
            cameraManager2.openCamera(string2, (CameraDevice.StateCallback)cameraManager, handler);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", interruptedException);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createCameraPreviewSession() {
        Surface surface;
        Camera2Control camera2Control;
        Camera2Control camera2Control2;
        Camera2Control camera2Control3;
        Camera2Control camera2Control4;
        Camera2Control camera2Control5;
        SurfaceTexture surfaceTexture;
        try {
            surfaceTexture = this.textureView.getSurfaceTexture();
            if (!$assertionsDisabled) {
                if (surfaceTexture == null) throw new AssertionError();
            }
            Camera2Control camera2Control6 = this;
            camera2Control5 = camera2Control6;
            camera2Control4 = camera2Control6;
            camera2Control3 = camera2Control6;
            camera2Control2 = camera2Control6;
            camera2Control = camera2Control6;
            surfaceTexture.setDefaultBufferSize(this.previewSize.getWidth(), this.previewSize.getHeight());
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
            return;
        }
        Surface surface2 = surface;
        {
            surface = new Surface(surfaceTexture);
            surfaceTexture = camera2Control4.cameraDevice.createCaptureRequest(1);
        }
        {
            this.previewRequestBuilder = surfaceTexture;
            surfaceTexture.addTarget(surface2);
            int n = camera2Control3.flashMode;
            camera2Control.updateFlashMode(n, camera2Control2.previewRequestBuilder);
            camera2Control5.cameraDevice.createCaptureSession(Arrays.asList(surface2, this.imageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (this_.Camera2Control.this.cameraDevice == null) {
                        return;
                    }
                    3 v0 = this_;
                    Camera2Control.access$602(v0.Camera2Control.this, cameraCaptureSession);
                    v0.Camera2Control.this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                    Camera2Control.access$802(v0.Camera2Control.this, this_.Camera2Control.this.previewRequestBuilder.build());
                    CameraCaptureSession cameraCaptureSession2 = v0.Camera2Control.this.captureSession;
                    CaptureRequest captureRequest = this_.Camera2Control.this.previewRequest;
                    3 v3 = this_;
                    3 v4 = v3;
                    3 this_ = v3.Camera2Control.this.captureCallback;
                    try {
                        cameraCaptureSession2.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)this_, v4.Camera2Control.this.backgroundHandler);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                }
            }, null);
            return;
        }
    }

    private Size getOptimalSize(Size[] sizeArray, int n, int n2, int n3, int n4, Size object) {
        ArrayList<Size> arrayList;
        ArrayList arrayList2;
        Size size = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        ArrayList<Size> arrayList3 = arrayList;
        arrayList = new ArrayList<Size>();
        int n5 = size.getWidth();
        int n6 = size.getHeight();
        int n7 = sizeArray.length;
        for (int i = 0; i < n7; ++i) {
            Size size2 = sizeArray[i];
            if (size2.getWidth() > n3 || size2.getHeight() > n4 || size2.getHeight() != size2.getWidth() * n6 / n5) continue;
            if (size2.getWidth() >= n && size2.getHeight() >= n2) {
                ((ArrayList)object).add(size2);
                continue;
            }
            arrayList3.add(size2);
        }
        if (((ArrayList)object).size() > 0) {
            return Collections.min(object, this.sizeComparator);
        }
        n = sizeArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            object = sizeArray[n2];
            if (object.getWidth() < n3 || object.getHeight() < n4) continue;
            return object;
        }
        if (arrayList3.size() > 0) {
            return Collections.max(arrayList3, this.sizeComparator);
        }
        return sizeArray[0];
    }

    private void requestCameraPermission() {
        PermissionCallback permissionCallback = ((Camera2Control)((Object)permissionCallback)).permissionCallback;
        if (permissionCallback != null) {
            permissionCallback.onRequestPermission();
        }
    }

    /*
     * Exception decompiling
     */
    private void setUpCameraOutputs(int var1_2, int var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeCamera() {
        Throwable throwable2;
        Camera2Control camera2Control = this;
        camera2Control.cameraLock.acquire();
        if (camera2Control.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        if (this.imageReader != null) {
            this.imageReader.close();
            this.imageReader = null;
        }
        this.cameraLock.release();
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (InterruptedException interruptedException) {}
            {
                throw new RuntimeException("Interrupted while trying to lock camera closing.", interruptedException);
            }
        }
        this.cameraLock.release();
        throw throwable2;
    }

    private void startBackgroundThread() {
        this.backgroundThread = new HandlerThread("ocr_camera");
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        HandlerThread handlerThread = this.backgroundThread;
        if (handlerThread != null) {
            Camera2Control camera2Control = this;
            handlerThread.quitSafely();
            camera2Control.backgroundThread = null;
            camera2Control.backgroundHandler = null;
        }
    }

    private void configureTransform(int n, int n2) {
        if (this.textureView != null && this.previewSize != null && this.context != null) {
            RectF rectF;
            RectF rectF2;
            Matrix matrix;
            int n3 = this.orientation;
            Matrix matrix2 = matrix;
            matrix = new Matrix();
            RectF rectF3 = rectF2;
            float f = n;
            float f2 = n2;
            RectF rectF4 = rectF;
            Camera2Control camera2Control = this;
            float f3 = camera2Control.previewSize.getHeight();
            float f4 = camera2Control.previewSize.getWidth();
            rectF = new RectF(0.0f, 0.0f, f3, f4);
            f3 = new RectF(0.0f, 0.0f, f, f2).centerX();
            f4 = rectF3.centerY();
            if (1 != n3 && 3 != n3) {
                if (2 == n3) {
                    matrix2.postRotate(180.0f, f3, f4);
                }
            } else {
                float f5 = f2;
                f2 = f3 - rectF4.centerX();
                rectF4.offset(f2, f4 - rectF4.centerY());
                matrix2.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.FILL);
                float f6 = Math.max(f5 / (float)this.previewSize.getHeight(), f / (float)this.previewSize.getWidth());
                matrix2.postScale(f6, f6, f3, f4);
                matrix2.postRotate((float)((n3 - 2) * 90), f3, f4);
            }
            this.textureView.setTransform(matrix2);
            return;
        }
    }

    private void lockFocus() {
        if (camera2Control5.captureSession != null && camera2Control5.state == 0) {
            Camera2Control camera2Control = camera2Control5;
            camera2Control.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            camera2Control.state = 1;
            CameraCaptureSession cameraCaptureSession = camera2Control.captureSession;
            Camera2Control camera2Control2 = camera2Control5;
            Camera2Control camera2Control3 = camera2Control2;
            Camera2Control camera2Control4 = camera2Control2;
            Camera2Control camera2Control5 = camera2Control2.previewRequestBuilder.build();
            CameraCaptureSession.CaptureCallback captureCallback = camera2Control4.captureCallback;
            Handler handler = camera2Control3.backgroundHandler;
            try {
                cameraCaptureSession.capture((CaptureRequest)camera2Control5, captureCallback, handler);
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
        }
    }

    private void runPreCaptureSequence() {
        Camera2Control camera2Control = camera2Control5;
        camera2Control.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        camera2Control.state = 2;
        CameraCaptureSession cameraCaptureSession = camera2Control.captureSession;
        Camera2Control camera2Control2 = camera2Control5;
        Camera2Control camera2Control3 = camera2Control2;
        Camera2Control camera2Control4 = camera2Control2;
        Camera2Control camera2Control5 = camera2Control2.previewRequestBuilder.build();
        CameraCaptureSession.CaptureCallback captureCallback = camera2Control4.captureCallback;
        Handler handler = camera2Control3.backgroundHandler;
        try {
            cameraCaptureSession.capture((CaptureRequest)camera2Control5, captureCallback, handler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void captureStillPicture() {
        CameraCaptureSession.CaptureCallback captureCallback;
        if (camera2Control11.context == null) return;
        if (camera2Control11.cameraDevice == null) return;
        Camera2Control camera2Control = camera2Control11;
        Camera2Control camera2Control2 = camera2Control;
        Camera2Control camera2Control3 = camera2Control;
        Camera2Control camera2Control4 = camera2Control;
        Camera2Control camera2Control5 = camera2Control;
        Camera2Control camera2Control6 = camera2Control;
        CaptureRequest.Builder builder = camera2Control.cameraDevice.createCaptureRequest(2);
        Camera2Control camera2Control7 = camera2Control11;
        Camera2Control camera2Control8 = camera2Control7;
        Camera2Control camera2Control9 = camera2Control7;
        CaptureRequest.Builder builder2 = builder;
        builder2.addTarget(camera2Control11.imageReader.getSurface());
        builder2.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
        CaptureRequest.Key key = CaptureRequest.JPEG_ORIENTATION;
        builder.set(key, (Object)camera2Control9.getOrientation(camera2Control8.orientation));
        camera2Control5.updateFlashMode(camera2Control4.flashMode, builder);
        CameraCaptureSession.CaptureCallback captureCallback2 = captureCallback;
        captureCallback = new CameraCaptureSession.CaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull TotalCaptureResult totalCaptureResult) {
                Camera2Control.this.unlockFocus();
            }

            public void onCaptureFailed(@NonNull CameraCaptureSession cameraCaptureSession, @NonNull CaptureRequest captureRequest, @NonNull CaptureFailure captureFailure) {
                super.onCaptureFailed(cameraCaptureSession, captureRequest, captureFailure);
            }
        };
        camera2Control6.captureSession.stopRepeating();
        CameraCaptureSession cameraCaptureSession = camera2Control2.captureSession;
        Camera2Control camera2Control10 = camera2Control11;
        Camera2Control camera2Control11 = builder.build();
        builder = camera2Control10.backgroundHandler;
        cameraCaptureSession.capture((CaptureRequest)camera2Control11, captureCallback2, (Handler)builder);
        try {
            camera2Control3.state = 4;
            return;
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    private int getOrientation(int n) {
        return (ORIENTATIONS.get(n) + this.sensorOrientation + 270) % 360;
    }

    private void unlockFocus() {
        Camera2Control camera2Control = this;
        Camera2Control camera2Control2 = camera2Control;
        Camera2Control camera2Control3 = camera2Control;
        Camera2Control camera2Control4 = camera2Control;
        camera2Control.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        CameraCaptureSession cameraCaptureSession = camera2Control.captureSession;
        Camera2Control camera2Control5 = this;
        Camera2Control camera2Control6 = camera2Control5;
        Camera2Control camera2Control7 = camera2Control5;
        CaptureRequest captureRequest = camera2Control5.previewRequestBuilder.build();
        CameraCaptureSession.CaptureCallback captureCallback = camera2Control7.captureCallback;
        Handler handler = camera2Control6.backgroundHandler;
        cameraCaptureSession.capture(captureRequest, captureCallback, handler);
        camera2Control3.state = 0;
        CameraCaptureSession cameraCaptureSession2 = camera2Control4.captureSession;
        Camera2Control camera2Control8 = this;
        Camera2Control camera2Control9 = camera2Control8;
        Camera2Control camera2Control10 = camera2Control8;
        captureRequest = camera2Control8.previewRequest;
        captureCallback = camera2Control10.captureCallback;
        handler = camera2Control9.backgroundHandler;
        cameraCaptureSession2.setRepeatingRequest(captureRequest, captureCallback, handler);
        try {
            camera2Control2.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    private void updateFlashMode(int n, CaptureRequest.Builder builder) {
        if (n != 0) {
            if (n != 1) {
                builder.set(CaptureRequest.FLASH_MODE, (Object)1);
            } else {
                builder.set(CaptureRequest.FLASH_MODE, (Object)2);
            }
        } else {
            builder.set(CaptureRequest.FLASH_MODE, (Object)0);
        }
    }

    public static /* synthetic */ CameraDevice access$402(Camera2Control camera2Control, CameraDevice cameraDevice) {
        camera2Control.cameraDevice = cameraDevice;
        return cameraDevice;
    }

    public static /* synthetic */ CameraCaptureSession access$602(Camera2Control camera2Control, CameraCaptureSession cameraCaptureSession) {
        camera2Control.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    public static /* synthetic */ CaptureRequest access$802(Camera2Control camera2Control, CaptureRequest captureRequest) {
        camera2Control.previewRequest = captureRequest;
        return captureRequest;
    }

    public static /* synthetic */ int access$1202(Camera2Control camera2Control, int n) {
        camera2Control.state = n;
        return n;
    }

    static {
        $assertionsDisabled = Camera2Control.class.desiredAssertionStatus() ^ true;
        ORIENTATIONS = new SparseIntArray();
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    @Override
    public void setDetectCallback(ICameraControl.OnDetectPictureCallback onDetectPictureCallback) {
    }

    @Override
    public AtomicBoolean getAbortingScan() {
        return null;
    }

    @Override
    public void start() {
        Camera2Control camera2Control = this;
        camera2Control.startBackgroundThread();
        if (camera2Control.textureView.isAvailable()) {
            Camera2Control camera2Control2 = this;
            camera2Control2.openCamera(camera2Control2.textureView.getWidth(), this.textureView.getHeight());
            camera2Control2.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        } else {
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        }
    }

    @Override
    public void stop() {
        Camera2Control camera2Control = this;
        camera2Control.textureView.setSurfaceTextureListener(null);
        camera2Control.closeCamera();
        camera2Control.stopBackgroundThread();
    }

    @Override
    public void pause() {
        this.setFlashMode(0);
    }

    @Override
    public void resume() {
        this.state = 0;
    }

    @Override
    public View getDisplayView() {
        return this.textureView;
    }

    @Override
    public Rect getPreviewFrame() {
        return this.previewFrame;
    }

    @Override
    public void takePicture(ICameraControl.OnTakePictureCallback onTakePictureCallback) {
        this.onTakePictureCallback = onTakePictureCallback;
        this.lockFocus();
    }

    @Override
    public void setPermissionCallback(PermissionCallback permissionCallback) {
        this.permissionCallback = permissionCallback;
    }

    @Override
    public void setDisplayOrientation(@CameraView.Orientation int n) {
        this.orientation = n / 90;
    }

    @Override
    public void refreshPermission() {
        Camera2Control camera2Control = this;
        camera2Control.openCamera(camera2Control.textureView.getWidth(), this.textureView.getHeight());
    }

    @Override
    public void setFlashMode(int n) {
        if (camera2Control5.flashMode == n) {
            return;
        }
        Camera2Control camera2Control = camera2Control5;
        Camera2Control camera2Control2 = camera2Control5;
        camera2Control2.flashMode = n;
        camera2Control2.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
        camera2Control.updateFlashMode(n, camera2Control2.previewRequestBuilder);
        CaptureRequest captureRequest = camera2Control.previewRequestBuilder.build();
        camera2Control.previewRequest = captureRequest;
        CameraCaptureSession cameraCaptureSession = camera2Control.captureSession;
        CaptureRequest captureRequest2 = captureRequest;
        Camera2Control camera2Control3 = camera2Control5;
        Camera2Control camera2Control4 = camera2Control3;
        Camera2Control camera2Control5 = camera2Control3.captureCallback;
        try {
            cameraCaptureSession.setRepeatingRequest(captureRequest2, (CameraCaptureSession.CaptureCallback)camera2Control5, camera2Control4.backgroundHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getFlashMode() {
        return this.flashMode;
    }
}

