/*
 * Decompiled with CFR 0.152.
 */
package com.aitime.android.ocr.camera;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import androidx.core.app.ActivityCompat;
import com.aitime.android.ocr.camera.CameraThreadPool;
import com.aitime.android.ocr.camera.CameraView;
import com.aitime.android.ocr.camera.ICameraControl;
import com.aitime.android.ocr.camera.PermissionCallback;
import com.aitime.android.ocr.camera.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Camera1Control
implements ICameraControl {
    public int displayOrientation;
    public int cameraId;
    public int flashMode;
    public AtomicBoolean takingPicture;
    public AtomicBoolean abortingScan;
    public Context context;
    public Camera camera;
    public Camera.Parameters parameters;
    public PermissionCallback permissionCallback;
    public Rect previewFrame;
    public PreviewView previewView;
    public View displayView;
    public int rotation;
    public ICameraControl.OnDetectPictureCallback detectCallback;
    public int previewFrameCount;
    public Camera.Size optSize;
    public final int MODEL_NOSCAN;
    public final int MODEL_SCAN;
    public int detectType;
    public SurfaceTexture surfaceCache;
    public byte[] buffer;
    public Camera.PreviewCallback previewCallback;
    public TextureView.SurfaceTextureListener surfaceTextureListener;
    public Comparator<Camera.Size> sizeComparator;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRequestDetect(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream;
        block11: {
            Throwable throwable2;
            block10: {
                block12: {
                    int n3;
                    Camera1Control camera1Control;
                    YuvImage yuvImage;
                    ByteArrayOutputStream byteArrayOutputStream2;
                    YuvImage yuvImage2;
                    if (this.camera == null) return;
                    if (byArray == null) return;
                    if (this.optSize == null) {
                        return;
                    }
                    YuvImage yuvImage22 = yuvImage2;
                    Camera.Size size = this.optSize;
                    int n = size.width;
                    int n2 = size.height;
                    yuvImage2 = new YuvImage(byArray, 17, n, n2, null);
                    Object var3_7 = null;
                    byteArrayOutputStream = byteArrayOutputStream2;
                    try {
                        yuvImage = yuvImage22;
                        byteArrayOutputStream(byArray.length);
                        camera1Control = this;
                        n3 = 0;
                    }
                    catch (Throwable throwable2) {
                        byteArrayOutputStream = var3_7;
                        break block10;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        byteArrayOutputStream = var3_7;
                        break block11;
                    }
                    try {
                        int n4 = camera1Control.optSize.width;
                        int n5 = camera1Control.optSize.height;
                        yuvImage.compressToJpeg(new Rect(0, n3, n4, n5), 80, (OutputStream)byteArrayOutputStream);
                    }
                    catch (Throwable throwable2) {
                        break block10;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        break block11;
                    }
                    {
                        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                        if (this.detectCallback.onDetect(byArray2, this.getCameraRotation()) != 0) break block12;
                        this.clearPreviewCallback();
                    }
                }
                Utility.closeIOQuietly(byteArrayOutputStream);
                return;
            }
            Utility.closeIOQuietly(byteArrayOutputStream);
            throw throwable2;
        }
        Utility.closeIOQuietly(byteArrayOutputStream);
    }

    private void stopPreview() {
        Camera1Control camera1Control = camera1Control.camera;
        if (camera1Control != null) {
            camera1Control.stopPreview();
        }
    }

    private void takePictureByCamera(final ICameraControl.OnTakePictureCallback onTakePictureCallback) {
        Camera camera;
        try {
            camera = this.camera;
        }
        catch (RuntimeException runtimeException) {}
        camera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] byArray, Camera camera) {
                2 v0 = onTakePictureCallback2;
                v0.Camera1Control.this.startPreview(false);
                v0.Camera1Control.this.takingPicture.set(false);
                ICameraControl.OnTakePictureCallback onTakePictureCallback2 = v0.onTakePictureCallback;
                if (onTakePictureCallback2 != null) {
                    onTakePictureCallback2.onPictureTaken(byArray);
                }
            }
        });
    }

    public Camera1Control(Context context) {
        PreviewView previewView;
        Comparator<Camera.Size> comparator;
        TextureView.SurfaceTextureListener surfaceTextureListener;
        Camera.PreviewCallback previewCallback;
        Rect rect;
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2;
        Camera1Control camera1Control = this;
        camera1Control.displayOrientation = 0;
        camera1Control.cameraId = 0;
        Object object = atomicBoolean2;
        atomicBoolean2 = new AtomicBoolean(false);
        camera1Control.takingPicture = object;
        object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        camera1Control.abortingScan = object;
        object = rect;
        rect = new Rect();
        camera1Control.previewFrame = object;
        camera1Control.rotation = 0;
        camera1Control.previewFrameCount = 0;
        camera1Control.MODEL_NOSCAN = 0;
        camera1Control.MODEL_SCAN = 1;
        camera1Control.detectType = 0;
        camera1Control.buffer = null;
        object = previewCallback;
        previewCallback = new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] byArray, Camera camera) {
                if (Camera1Control.this.abortingScan.get()) {
                    return;
                }
                if (Camera1Control.this.previewFrameCount++ % 5 != 0) {
                    return;
                }
                if ((double)byArray.length != (double)(((Camera1Control)Camera1Control.this).parameters.getPreviewSize().width * ((Camera1Control)Camera1Control.this).parameters.getPreviewSize().height) * 1.5) {
                    return;
                }
                camera.addCallbackBuffer(Camera1Control.this.buffer);
                CameraThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        Camera1Control.this.onRequestDetect(byArray);
                    }
                });
            }
        };
        camera1Control.previewCallback = object;
        object = surfaceTextureListener;
        surfaceTextureListener = new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
                4 v0 = this;
                Camera1Control.access$902(v0.Camera1Control.this, surfaceTexture);
                v0.Camera1Control.this.initCamera();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
                4 v0 = this;
                Camera1Control camera1Control = v0.Camera1Control.this;
                camera1Control.opPreviewSize(camera1Control.previewView.getWidth(), Camera1Control.this.previewView.getHeight());
                v0.Camera1Control.this.startPreview(false);
                v0.Camera1Control.this.setPreviewCallbackImpl();
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
                Camera1Control.this.setPreviewCallbackImpl();
            }
        };
        camera1Control.surfaceTextureListener = object;
        object = comparator;
        comparator = new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size size, Camera.Size size2) {
                return Long.signum((long)size.width * (long)size.height - (long)size2.width * (long)size2.height);
            }
        };
        camera1Control.sizeComparator = object;
        camera1Control.context = context;
        object = previewView;
        previewView = new PreviewView(context);
        camera1Control.previewView = object;
        camera1Control.openCamera();
    }

    private void openCamera() {
        this.setupDisplayView();
    }

    private void setupDisplayView() {
        TextureView textureView;
        TextureView textureView2 = textureView;
        Camera1Control camera1Control = this;
        textureView2(this.context);
        PreviewView.access$002(camera1Control.previewView, textureView2);
        camera1Control.previewView.setTextureView(textureView2);
        camera1Control.displayView = camera1Control.previewView;
        textureView.setSurfaceTextureListener(camera1Control.surfaceTextureListener);
    }

    private void setPreviewCallbackImpl() {
        Camera camera;
        if (this.buffer == null) {
            this.buffer = new byte[this.displayView.getWidth() * this.displayView.getHeight() * ImageFormat.getBitsPerPixel((int)17) / 8];
        }
        if ((camera = this.camera) != null && this.detectType == 1) {
            camera.addCallbackBuffer(this.buffer);
            this.camera.setPreviewCallback(this.previewCallback);
        }
    }

    private void clearPreviewCallback() {
        Camera camera = this.camera;
        if (camera != null && this.detectType == 1) {
            camera.setPreviewCallback(null);
            this.stopPreview();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCamera() {
        if (this.camera != null) ** GOTO lbl19
        var1_1 = v0;
        v0 = new Camera.CameraInfo();
        for (var2_2 = 0; var2_2 < Camera.getNumberOfCameras(); ++var2_2) {
            Camera.getCameraInfo((int)var2_2, (Camera.CameraInfo)var1_1);
            if (var1_1.facing != 0) continue;
            this.cameraId = var2_2;
        }
        try {
            this.camera = Camera.open((int)this.cameraId);
            ** GOTO lbl19
        }
        catch (Throwable v1) {
            v1.printStackTrace();
            this.startPreview(true);
            return;
lbl19:
            // 2 sources

            if (this.parameters != null) ** GOTO lbl24
            v2 = this.camera.getParameters();
            try {
                this.parameters = v2;
                v2.setPreviewFormat(17);
lbl24:
                // 2 sources

                v3 = this;
                v3.opPreviewSize(v3.previewView.getWidth(), this.previewView.getHeight());
                v3.camera.setPreviewTexture(this.surfaceCache);
                v3.setPreviewCallbackImpl();
                v3.startPreview(false);
                return;
            }
            catch (IOException v4) {
                v4.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startPreview(boolean bl) {
        if (ActivityCompat.checkSelfPermission((Context)((Camera1Control)((Object)permissionCallback)).context, (String)"android.permission.CAMERA") != 0) {
            if (!bl) return;
            PermissionCallback permissionCallback = ((Camera1Control)((Object)permissionCallback)).permissionCallback;
            if (permissionCallback == null) return;
            permissionCallback.onRequestPermission();
            return;
        }
        try {
            if (((Camera1Control)((Object)permissionCallback)).camera == null) {
                ((Camera1Control)((Object)permissionCallback)).initCamera();
                return;
            }
            Camera1Control camera1Control = permissionCallback;
            camera1Control.camera.startPreview();
            camera1Control.startAutoFocus();
            return;
        }
        catch (RuntimeException runtimeException) {}
    }

    private void cancelAutoFocus() {
        this.camera.cancelAutoFocus();
        CameraThreadPool.cancelAutoFocusTimer();
    }

    private void startAutoFocus() {
        CameraThreadPool.createAutoFocusTimerTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                5 v0 = this;
                Camera1Control camera1Control = v0.Camera1Control.this;
                synchronized (camera1Control) {
                    block7: {
                        if (v0.Camera1Control.this.camera == null) break block7;
                        if (Camera1Control.this.takingPicture.get()) break block7;
                        try {
                            Camera1Control.this.camera.autoFocus(new Camera.AutoFocusCallback(){

                                public void onAutoFocus(boolean bl, Camera camera) {
                                }
                            });
                        }
                        catch (Throwable throwable) {}
                    }
                    return;
                }
            }
        });
    }

    private void opPreviewSize(int n, int n2) {
        block9: {
            if (this.parameters == null) break block9;
            if (this.camera == null || n <= 0) break block9;
            Camera1Control camera1Control = this;
            Camera1Control camera1Control2 = camera1Control;
            Camera1Control camera1Control3 = camera1Control;
            Camera1Control camera1Control4 = camera1Control;
            Camera1Control camera1Control5 = camera1Control;
            Camera1Control camera1Control6 = camera1Control;
            Camera1Control camera1Control7 = camera1Control;
            Camera.Size size = camera1Control.getOptimalSize(camera1Control.camera.getParameters().getSupportedPreviewSizes());
            camera1Control6.optSize = size;
            Camera.Parameters parameters = camera1Control7.parameters;
            Camera.Size size2 = size;
            Camera.Size size3 = size2;
            int n3 = size2.width;
            parameters.setPreviewSize(n3, size3.height);
            PreviewView previewView = camera1Control4.previewView;
            float f = 1.0f;
            float f2 = this.optSize.width;
            float f3 = f2 * f / (float)this.optSize.height;
            try {
                previewView.setRatio(f3);
                camera1Control5.camera.setDisplayOrientation(this.getSurfaceOrientation());
                camera1Control2.stopPreview();
                camera1Control3.camera.setParameters(this.parameters);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Camera.Size getOptimalSize(List<Camera.Size> size) {
        ArrayList<Camera.Size> arrayList;
        Camera.Size size2 = size;
        Camera1Control camera1Control = iterator;
        int n = camera1Control.previewView.textureView.getWidth();
        int n2 = camera1Control.previewView.textureView.getHeight();
        Camera.Size size3 = (Camera.Size)size2.get(0);
        ArrayList<Camera.Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size4 : size2) {
            int n3;
            int n4 = size4.width;
            if ((n4 < n || (n3 = size4.height) < n2 || n4 * n2 != n3 * n) && ((n4 = size4.height) < n || (n3 = size4.width) < n2 || n3 * n != n4 * n2)) continue;
            arrayList2.add(size4);
        }
        if (!arrayList2.isEmpty()) {
            return Collections.min(arrayList2, ((Camera1Control)((Object)iterator)).sizeComparator);
        }
        Iterator iterator = size.iterator();
        do {
            if (!iterator.hasNext()) {
                return size3;
            }
            size = (Camera.Size)iterator.next();
        } while (size.width <= n || size.height <= n2);
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFlashMode(int n) {
        try {
            if (this.parameters == null) {
                return;
            }
            if (n != 0) {
                if (n != 1) {
                    this.parameters.setFlashMode("auto");
                } else {
                    this.parameters.setFlashMode("torch");
                }
            } else {
                this.parameters.setFlashMode("off");
            }
            if (this.camera == null) return;
            this.camera.setParameters(this.parameters);
            return;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private int getSurfaceOrientation() {
        int n = this.displayOrientation;
        if (n != 90) {
            if (n != 270) {
                return 90;
            }
            return 180;
        }
        return 0;
    }

    public static /* synthetic */ SurfaceTexture access$902(Camera1Control camera1Control, SurfaceTexture surfaceTexture) {
        camera1Control.surfaceCache = surfaceTexture;
        return surfaceTexture;
    }

    public int getCameraRotation() {
        return this.rotation;
    }

    @Override
    public AtomicBoolean getAbortingScan() {
        return this.abortingScan;
    }

    @Override
    public void setDetectCallback(ICameraControl.OnDetectPictureCallback onDetectPictureCallback) {
        Camera1Control camera1Control = this;
        camera1Control.detectType = 1;
        camera1Control.detectCallback = onDetectPictureCallback;
    }

    @Override
    public void setDisplayOrientation(@CameraView.Orientation int n) {
        this.displayOrientation = n;
        this.rotation = n != 0 ? (n != 90 && n == 270 ? 180 : 0) : 90;
        this.previewView.requestLayout();
    }

    @Override
    public void refreshPermission() {
        this.startPreview(true);
    }

    @Override
    public void setFlashMode(int n) {
        if (this.flashMode == n) {
            return;
        }
        this.flashMode = n;
        this.updateFlashMode(n);
    }

    @Override
    public int getFlashMode() {
        return this.flashMode;
    }

    @Override
    public void start() {
        this.startPreview(false);
    }

    @Override
    public void stop() {
        Camera camera = this.camera;
        if (camera != null) {
            Camera1Control camera1Control = this;
            camera.setPreviewCallback(null);
            camera1Control.stopPreview();
            this.camera = null;
            camera1Control.camera.release();
            camera1Control.camera = null;
            camera1Control.buffer = null;
        }
    }

    @Override
    public void pause() {
        if (this.camera != null) {
            this.stopPreview();
        }
        this.setFlashMode(0);
    }

    @Override
    public void resume() {
        Camera1Control camera1Control = this;
        camera1Control.takingPicture.set(false);
        if (camera1Control.camera == null) {
            this.openCamera();
        } else {
            Camera1Control camera1Control2 = this;
            camera1Control2.previewView.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
            if (camera1Control2.previewView.textureView.isAvailable()) {
                this.startPreview(false);
            }
        }
    }

    @Override
    public View getDisplayView() {
        return this.displayView;
    }

    @Override
    public void takePicture(final ICameraControl.OnTakePictureCallback onTakePictureCallback) {
        if (this.takingPicture.get()) {
            return;
        }
        int n = this.displayOrientation;
        if (n != 0) {
            if (n != 90) {
                if (n == 270) {
                    this.parameters.setRotation(180);
                }
            } else {
                this.parameters.setRotation(0);
            }
        } else {
            this.parameters.setRotation(90);
        }
        Camera1Control camera1Control = this;
        Camera1Control camera1Control2 = camera1Control;
        Camera1Control camera1Control3 = camera1Control;
        Camera1Control camera1Control4 = camera1Control;
        Camera1Control camera1Control5 = camera1Control;
        Camera.Size size = camera1Control.getOptimalSize(camera1Control.camera.getParameters().getSupportedPictureSizes());
        Camera.Parameters parameters = camera1Control4.parameters;
        Camera.Size size2 = size;
        Camera.Size size3 = size2;
        int n2 = size2.width;
        try {
            parameters.setPictureSize(n2, size3.height);
            camera1Control5.camera.setParameters(this.parameters);
            camera1Control2.takingPicture.set(true);
            camera1Control3.cancelAutoFocus();
            CameraThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    Camera1Control.this.takePictureByCamera(onTakePictureCallback);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            Camera1Control camera1Control6 = this;
            camera1Control6.startPreview(false);
            camera1Control6.takingPicture.set(false);
        }
    }

    @Override
    public void setPermissionCallback(PermissionCallback permissionCallback) {
        this.permissionCallback = permissionCallback;
    }

    @Override
    public Rect getPreviewFrame() {
        return this.previewFrame;
    }

    public class PreviewView
    extends FrameLayout {
        public TextureView textureView;
        public float ratio;

        public PreviewView(Context context) {
            super(context);
            this.ratio = 0.75f;
        }

        private void relayout(int n, int n2) {
            if (n < n2) {
                n2 = (int)((float)n * this.ratio);
            } else {
                n = (int)((float)n2 * this.ratio);
            }
            PreviewView previewView = this;
            int n3 = (previewView.getWidth() - n) / 2;
            int n4 = (previewView.getHeight() - n2) / 2;
            ((Camera1Control)previewView.Camera1Control.this).previewFrame.left = n3;
            ((Camera1Control)previewView.Camera1Control.this).previewFrame.top = n4;
            ((Camera1Control)previewView.Camera1Control.this).previewFrame.right = n3 + n;
            ((Camera1Control)previewView.Camera1Control.this).previewFrame.bottom = n4 + n2;
        }

        public static /* synthetic */ TextureView access$002(PreviewView previewView, TextureView textureView) {
            previewView.textureView = textureView;
            return textureView;
        }

        public void setTextureView(TextureView textureView) {
            PreviewView previewView = this;
            previewView.textureView = textureView;
            previewView.removeAllViews();
            previewView.addView((View)textureView);
        }

        public void setRatio(float f) {
            PreviewView previewView = this;
            previewView.ratio = f;
            previewView.requestLayout();
            int n = previewView.getWidth();
            previewView.relayout(n, previewView.getHeight());
        }

        public void onSizeChanged(int n, int n2, int n3, int n4) {
            PreviewView previewView = this;
            super.onSizeChanged(n, n2, n3, n4);
            previewView.relayout(n, n2);
        }

        /*
         * WARNING - void declaration
         */
        public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            void var5_7;
            void var4_6;
            void var3_5;
            int n5;
            PreviewView previewView = this;
            super.onLayout(bl, n5, (int)var3_5, (int)var4_6, (int)var5_7);
            PreviewView previewView2 = this;
            int n52 = ((Camera1Control)previewView2.Camera1Control.this).previewFrame.top;
            int n6 = ((Camera1Control)previewView2.Camera1Control.this).previewFrame.right;
            n5 = ((Camera1Control)previewView2.Camera1Control.this).previewFrame.bottom;
            previewView.textureView.layout(((Camera1Control)Camera1Control.this).previewFrame.left, n52, n6, n5);
        }
    }
}

