/*
 * Decompiled with CFR 0.152.
 */
package com.airsaid.imagecomparator;

import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import com.airsaid.imagecomparator.Comparison;
import com.airsaid.imagecomparator.ComparisonHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/airsaid/imagecomparator/DifferencesHashComparison;", "Lcom/airsaid/imagecomparator/Comparison;", "()V", "comparison", "", "sourceImage", "Landroid/graphics/Bitmap;", "targetImage", "getDHash", "", "bitmap", "image-comparator_release"})
public final class DifferencesHashComparison
implements Comparison {
    @Override
    public float comparison(@NotNull Bitmap sourceImage, @NotNull Bitmap targetImage) {
        Intrinsics.checkParameterIsNotNull((Object)sourceImage, (String)"sourceImage");
        Intrinsics.checkParameterIsNotNull((Object)targetImage, (String)"targetImage");
        Bitmap sourceBitmap = ThumbnailUtils.extractThumbnail((Bitmap)sourceImage, (int)8, (int)8);
        Bitmap targetBitmap = ThumbnailUtils.extractThumbnail((Bitmap)targetImage, (int)8, (int)8);
        Bitmap bitmap = sourceBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"sourceBitmap");
        sourceBitmap = ComparisonHelper.INSTANCE.convertToGreyBitmap(bitmap);
        Bitmap bitmap2 = targetBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"targetBitmap");
        targetBitmap = ComparisonHelper.INSTANCE.convertToGreyBitmap(bitmap2);
        String sourceDHash = this.getDHash(sourceBitmap);
        String targetDHash = this.getDHash(targetBitmap);
        int distance = ComparisonHelper.INSTANCE.getHammingDistance(sourceDHash, targetDHash);
        return ComparisonHelper.INSTANCE.getPercent(distance, sourceDHash.length());
    }

    /*
     * WARNING - void declaration
     */
    private final String getDHash(Bitmap bitmap) {
        StringBuilder sb = new StringBuilder();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void i;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void j;
                void r = j + true;
                if (r < width) {
                    int leftPixel = pixels[width * i + j];
                    int rightPixel = pixels[width * i + r];
                    if (leftPixel > rightPixel) {
                        sb.append(1);
                    } else {
                        sb.append(0);
                    }
                }
                ++j;
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }
}

