/*
 * Decompiled with CFR 0.152.
 */
package com.airsaid.imagecomparator;

import android.graphics.Bitmap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lcom/airsaid/imagecomparator/ComparisonHelper;", "", "()V", "convertToGreyBitmap", "Landroid/graphics/Bitmap;", "bitmap", "getHammingDistance", "", "hash1", "", "hash2", "getPercent", "", "distance", "maxDistance", "image-comparator_release"})
public final class ComparisonHelper {
    public static final ComparisonHelper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap convertToGreyBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int alpha = -16777216;
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void i;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void j;
                int original = pixels[width * i + j];
                int red = (original & 0xFF0000) >> 16;
                int green = (original & 0xFF00) >> 8;
                int blue = original & 0xFF;
                int grey = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                pixels[width * i + j] = grey = alpha | grey << 16 | grey << 8 | grey;
                ++j;
            }
            ++i;
        }
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        result.setPixels(pixels, 0, width, 0, 0, width, height);
        Bitmap bitmap2 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"result");
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getHammingDistance(@NotNull String hash1, @NotNull String hash2) {
        Intrinsics.checkParameterIsNotNull((Object)hash1, (String)"hash1");
        Intrinsics.checkParameterIsNotNull((Object)hash2, (String)"hash2");
        String string = hash1;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars1 = cArray;
        String string2 = hash2;
        char[] cArray2 = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
        char[] chars2 = cArray2;
        int distance = 0;
        int n = 0;
        int n2 = chars1.length;
        while (n < n2) {
            void i;
            if (chars1[i] != chars2[i]) {
                ++distance;
            }
            ++i;
        }
        return distance;
    }

    public final float getPercent(int distance, int maxDistance) {
        return 100.0f / (float)maxDistance * (float)(maxDistance - distance);
    }

    private ComparisonHelper() {
    }

    static {
        ComparisonHelper comparisonHelper;
        INSTANCE = comparisonHelper = new ComparisonHelper();
    }
}

