/*
 * Decompiled with CFR 0.152.
 */
package com.airsaid.imagecomparator;

import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import com.airsaid.imagecomparator.Comparison;
import com.airsaid.imagecomparator.ComparisonHelper;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/airsaid/imagecomparator/AverageHashComparison;", "Lcom/airsaid/imagecomparator/Comparison;", "()V", "binaryString2HexString", "", "binaryString", "comparison", "", "sourceImage", "Landroid/graphics/Bitmap;", "targetImage", "getAverage", "", "bitmap", "getBinary", "average", "image-comparator_release"})
public final class AverageHashComparison
implements Comparison {
    @Override
    public float comparison(@NotNull Bitmap sourceImage, @NotNull Bitmap targetImage) {
        Intrinsics.checkParameterIsNotNull((Object)sourceImage, (String)"sourceImage");
        Intrinsics.checkParameterIsNotNull((Object)targetImage, (String)"targetImage");
        Bitmap sourceBitmap = ThumbnailUtils.extractThumbnail((Bitmap)sourceImage, (int)8, (int)8);
        Bitmap targetBitmap = ThumbnailUtils.extractThumbnail((Bitmap)targetImage, (int)8, (int)8);
        Bitmap bitmap = sourceBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"sourceBitmap");
        sourceBitmap = ComparisonHelper.INSTANCE.convertToGreyBitmap(bitmap);
        Bitmap bitmap2 = targetBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"targetBitmap");
        targetBitmap = ComparisonHelper.INSTANCE.convertToGreyBitmap(bitmap2);
        int sourceAverage = this.getAverage(sourceBitmap);
        int targetAverage = this.getAverage(targetBitmap);
        String sourceBinary = this.getBinary(sourceBitmap, sourceAverage);
        String targetBinary = this.getBinary(targetBitmap, targetAverage);
        String sourceHexString = this.binaryString2HexString(sourceBinary);
        String targetHexString = this.binaryString2HexString(targetBinary);
        int distance = ComparisonHelper.INSTANCE.getHammingDistance(sourceHexString, targetHexString);
        return ComparisonHelper.INSTANCE.getPercent(distance, sourceHexString.length());
    }

    private final int getAverage(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int avgPixel = 0;
        int n = pixels.length;
        for (int i = 0; i < n; ++i) {
            int pixel = pixels[i];
            avgPixel += pixel;
        }
        return avgPixel / pixels.length;
    }

    /*
     * WARNING - void declaration
     */
    private final String getBinary(Bitmap bitmap, int average) {
        StringBuilder sb = new StringBuilder();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void i;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void j;
                int original = pixels[width * i + j];
                pixels[width * i + j] = original >= average ? 1 : 0;
                sb.append(pixels[width * i + j]);
                ++j;
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String binaryString2HexString(String binaryString) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < binaryString.length(); index += 4) {
            int temporary = 0;
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                String string;
                void j;
                String string2 = binaryString;
                int n3 = index + j;
                int n4 = index + j + 1;
                int n5 = temporary;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                temporary = n5 + (Integer.parseInt(string) << 4 - j - 1);
                ++j;
            }
            sb.append(Integer.toHexString(temporary));
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }
}

