/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Zipper {
    private static final int BUFFER_SIZE = 1024;
    static final String UTF8 = "UTF8";

    public static void gzip(File original, File compressed) throws IOException {
        FileInputStream orig = new FileInputStream(original);
        FileOutputStream comp = new FileOutputStream(compressed);
        Zipper.gzip(orig, comp);
        ((InputStream)orig).close();
        comp.flush();
        comp.close();
    }

    public static void gzip(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(in);
        GZIPOutputStream zos = new GZIPOutputStream(new BufferedOutputStream(out));
        while ((read = bis.read(buffer)) > 0) {
            zos.write(buffer, 0, read);
        }
        zos.flush();
        zos.close();
    }

    public static byte[] gzip(String string) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        gos.write(string.getBytes(UTF8));
        gos.close();
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public static void gunzip(File compressed, File output) throws IOException {
        FileInputStream comp = new FileInputStream(compressed);
        FileOutputStream decomp = new FileOutputStream(output);
        Zipper.gunzip(comp, decomp);
        comp.close();
        decomp.close();
    }

    public static void gunzip(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        GZIPInputStream zis = new GZIPInputStream(new BufferedInputStream(in));
        BufferedOutputStream bos = new BufferedOutputStream(out);
        while ((read = zis.read(buffer)) > 0) {
            bos.write(buffer, 0, read);
        }
        bos.flush();
        bos.close();
    }

    public static byte[] gunzip(byte[] cmopressed) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        ByteArrayInputStream bis = new ByteArrayInputStream(cmopressed);
        GZIPInputStream zis = new GZIPInputStream(new BufferedInputStream(bis));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = zis.read(buffer)) > 0) {
            bos.write(buffer, 0, read);
        }
        zis.close();
        bis.close();
        byte[] bytes = bos.toByteArray();
        bos.close();
        return bytes;
    }

    private Zipper() {
    }
}

