/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.io;

import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Hasher {
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String SHA_1_ALGORITHM = "SHA-1";
    static final String MD5_ALGORITHM = "MD5";
    static final String UTF8_CHARSET = "UTF-8";

    public static String sha1(@NonNull String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return Hasher.hashStringWithAlgorithm(string, SHA_1_ALGORITHM);
    }

    public static String sha1(@NonNull File file) throws IOException, NoSuchAlgorithmException {
        return Hasher.hashFileWithAlgorithm(file, SHA_1_ALGORITHM);
    }

    public static String sha1(@NonNull InputStream in) throws IOException, NoSuchAlgorithmException {
        return Hasher.hashStreamWithAlgorithm(in, SHA_1_ALGORITHM);
    }

    public static String md5(@NonNull String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return Hasher.hashStringWithAlgorithm(string, MD5_ALGORITHM);
    }

    public static String md5(@NonNull File file) throws IOException, NoSuchAlgorithmException {
        return Hasher.hashFileWithAlgorithm(file, MD5_ALGORITHM);
    }

    public static String md5(@NonNull InputStream in) throws IOException, NoSuchAlgorithmException {
        return Hasher.hashStreamWithAlgorithm(in, MD5_ALGORITHM);
    }

    public static String hashStringWithAlgorithm(@NonNull String string, @NonNull String algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        return Hasher.encodeHexString(digest.digest(string.getBytes(UTF8_CHARSET)));
    }

    private static String hashFileWithAlgorithm(@NonNull File file, @NonNull String algorithm) throws IOException, NoSuchAlgorithmException {
        return Hasher.hashStreamWithAlgorithm(new FileInputStream(file), algorithm);
    }

    private static String hashStreamWithAlgorithm(@NonNull InputStream in, @NonNull String algorithm) throws NoSuchAlgorithmException, IOException {
        int read;
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        in.close();
        return Hasher.encodeHexString(digest.digest());
    }

    public static String encodeHexString(@NonNull byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int c = 0;
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte aByte;
            byte b = aByte = byArray[i];
            buf[c++] = HEX_CHAR[b >> 4 & 0xF];
            buf[c++] = HEX_CHAR[b & 0xF];
        }
        return new String(buf);
    }

    private Hasher() {
    }
}

