/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.logging;

import android.support.annotation.Nullable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LogCatcher {
    private static final String LOGCAT_EXEC = "logcat";
    private static final String ARG_DUMP = "-d";
    private static final String ARG_CLEAR = "-c";
    private static final String ARG_PID = "--pid";
    private static final int PID_NONE = -1;
    private final Executor callbackExecutor;
    private final int pid;
    private final Object lock = new Object();
    private volatile boolean clearing = false;
    private volatile boolean capturing = false;
    private volatile Process captureProcess = null;
    private LogReader captureTask = null;

    public LogCatcher(boolean clear, int processId, @Nullable Executor executor) {
        this.pid = processId;
        Executor executor2 = this.callbackExecutor = null == executor ? Executors.newSingleThreadExecutor() : executor;
        if (clear) {
            this.clear();
        }
    }

    public LogCatcher(boolean clear, boolean self, Executor executor) {
        this(clear, self ? android.os.Process.myPid() : -1, executor);
    }

    public LogCatcher(boolean clear, boolean self) {
        this(clear, self, null);
    }

    public LogCatcher() {
        this(false, false, null);
    }

    public LogCatcher(boolean clear) {
        this(clear, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(OnLogLinesListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.capturing) {
                throw new IllegalStateException("Capture already in progress");
            }
            LogCatcher.DEBUG("dump: waiting for clear to finish", new Object[0]);
            this.waitForClearEnd();
            LogCatcher.DEBUG("dump: dumping...", new Object[0]);
            this.capturing = true;
            this.callbackExecutor.execute(new LogReader(listener, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(OnLogLinesListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.capturing) {
                throw new IllegalStateException("Capture already in progress");
            }
            this.waitForClearEnd();
            this.capturing = true;
            InternalLogLinesListener logcatListener = new InternalLogLinesListener(listener){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onProcessStarted(Process process) {
                    Object object = LogCatcher.this.lock;
                    synchronized (object) {
                        LogCatcher.this.captureProcess = process;
                        LogCatcher.this.lock.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onProcessFinished(int exitCode) {
                    Object object = LogCatcher.this.lock;
                    synchronized (object) {
                        LogCatcher.this.capturing = false;
                        LogCatcher.this.captureProcess = null;
                        LogCatcher.this.lock.notifyAll();
                    }
                }
            };
            LogCatcher.DEBUG("capture: capturing...", new Object[0]);
            this.captureTask = new LogReader(logcatListener, false);
            this.callbackExecutor.execute(this.captureTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCapture() {
        Object object = this.lock;
        synchronized (object) {
            if (null == this.captureTask) {
                throw new IllegalStateException("Not capturing");
            }
            LogCatcher.DEBUG("capture: stopping...", new Object[0]);
            this.captureTask.stop();
        }
    }

    public static void clearLog() {
        LogCatcher.DEBUG("clear", new Object[0]);
        new LogEraser().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clearing) {
                throw new IllegalStateException("Clear already in progress");
            }
            this.waitForCaptureEnd();
            this.clearing = true;
            LogCatcher.DEBUG("clear: clearing...", new Object[0]);
            this.callbackExecutor.execute(new LogEraser(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onComplete(int exitCode) {
                    Object object = LogCatcher.this.lock;
                    synchronized (object) {
                        LogCatcher.this.clearing = false;
                        LogCatcher.DEBUG("clear: complete", new Object[0]);
                        LogCatcher.this.lock.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onError(Exception e) {
                    Object object = LogCatcher.this.lock;
                    synchronized (object) {
                        LogCatcher.this.clearing = false;
                        LogCatcher.DEBUG("clear: failed", new Object[0]);
                        LogCatcher.this.lock.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForClearEnd() {
        Object object = this.lock;
        synchronized (object) {
            LogCatcher.DEBUG("waiting for clear to finish", new Object[0]);
            while (this.clearing) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCaptureEnd() {
        Object object = this.lock;
        synchronized (object) {
            LogCatcher.DEBUG("waiting for current capture task to finish", new Object[0]);
            while (this.capturing) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        }
    }

    private static void DEBUG(String fmt, Object ... args) {
    }

    private static abstract class InternalLogLinesListener
    implements OnLogLinesListener {
        private final OnLogLinesListener listener;

        protected InternalLogLinesListener(OnLogLinesListener delegate) {
            this.listener = delegate;
        }

        @Override
        public final void onError(Throwable t) {
            this.listener.onError(t);
        }

        @Override
        public void onStart() {
            this.listener.onStart();
        }

        @Override
        public final void onFinished() {
            this.listener.onFinished();
        }

        @Override
        public final void onLogLine(String logLine) {
            this.listener.onLogLine(logLine);
        }

        abstract void onProcessStarted(Process var1);

        abstract void onProcessFinished(int var1);
    }

    public static interface OnLogLinesListener {
        public void onLogLine(String var1);

        public void onStart();

        public void onFinished();

        public void onError(Throwable var1);
    }

    private static class LogEraser
    implements Runnable {
        private LogEraser() {
        }

        @Override
        public final void run() {
            try {
                LogCatcher.DEBUG("eraser: Started '%s %s'", new Object[]{LogCatcher.LOGCAT_EXEC, LogCatcher.ARG_CLEAR});
                this.onComplete(new ProcessBuilder(new String[0]).command(LogCatcher.LOGCAT_EXEC, LogCatcher.ARG_CLEAR).start().waitFor());
                LogCatcher.DEBUG("eraser: '%s %s' finished", new Object[]{LogCatcher.LOGCAT_EXEC, LogCatcher.ARG_CLEAR});
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onError(e);
            }
        }

        protected void onError(Exception e) {
        }

        protected void onComplete(int exitCode) {
        }
    }

    private class LogReader
    implements Runnable {
        private final OnLogLinesListener listener;
        private final boolean dump;
        private Process logcatProcess = null;
        private final AtomicBoolean stopped = new AtomicBoolean(false);

        private LogReader(OnLogLinesListener logLinesListener, boolean dumpOnly) {
            this.listener = logLinesListener;
            this.dump = dumpOnly;
        }

        private LogReader(OnLogLinesListener logLinesListener) {
            this(logLinesListener, true);
        }

        @Override
        public void run() {
            ArrayList<String> commandline = new ArrayList<String>();
            commandline.add(LogCatcher.LOGCAT_EXEC);
            if (LogCatcher.this.pid != -1) {
                Collections.addAll(commandline, LogCatcher.ARG_PID, String.valueOf(LogCatcher.this.pid));
            }
            if (this.dump) {
                commandline.add(LogCatcher.ARG_DUMP);
            }
            LogCatcher.DEBUG("reader: starting logcat process with params: %s", new Object[]{((Object)commandline).toString()});
            try {
                String line;
                InternalLogLinesListener processListner;
                this.logcatProcess = new ProcessBuilder(commandline).start();
                LogCatcher.DEBUG("reader: Started logcat.", new Object[0]);
                this.listener.onStart();
                InternalLogLinesListener internalLogLinesListener = processListner = this.listener instanceof InternalLogLinesListener ? (InternalLogLinesListener)this.listener : null;
                if (null != processListner) {
                    processListner.onProcessStarted(this.logcatProcess);
                }
                BufferedReader logcat = new BufferedReader(new InputStreamReader(this.logcatProcess.getInputStream()));
                while ((line = logcat.readLine()) != null) {
                    this.listener.onLogLine(line);
                    if (!this.stopped.get()) continue;
                    LogCatcher.DEBUG("reader: Stop requested. killing logcat.", new Object[0]);
                    this.logcatProcess.destroy();
                    break;
                }
                LogCatcher.DEBUG("reader: No more lines.", new Object[0]);
                logcat.close();
                this.listener.onFinished();
                if (null != processListner) {
                    this.logcatProcess.destroy();
                    processListner.onProcessFinished(this.logcatProcess.waitFor());
                }
                this.logcatProcess = null;
            }
            catch (Exception e) {
                if (this.stopped.get()) {
                    LogCatcher.this.captureProcess.destroy();
                    this.listener.onFinished();
                }
                this.listener.onError(e);
            }
        }

        public void stop() {
            this.stopped.set(true);
        }
    }
}

