/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.logging;

import com.airg.android.logging.Logger;

public class TaggedLogger {
    private final String tag;

    TaggedLogger(String logtag) {
        this.tag = logtag;
    }

    public void e(Throwable throwable) {
        this.e(throwable, null);
    }

    public void e(Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.error(this.tag, Logger.format(throwable, msg));
    }

    public void w(Throwable throwable) {
        this.w(throwable, null);
    }

    public void w(Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.warn(this.tag, Logger.format(throwable, msg));
    }

    public void d(Throwable throwable) {
        this.d(null, throwable);
    }

    public void d(Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.debug(this.tag, Logger.format(throwable, msg));
    }

    public void e(String fmt, Object ... args) {
        Logger.error(this.tag, Logger.expand(fmt, args));
    }

    public void e(String str) {
        Logger.error(this.tag, str);
    }

    public void w(String fmt, Object ... args) {
        Logger.warn(this.tag, Logger.expand(fmt, args));
    }

    public void w(String str) {
        Logger.warn(this.tag, str);
    }

    public void i(String fmt, Object ... args) {
        Logger.info(this.tag, Logger.expand(fmt, args));
    }

    public void i(String str) {
        Logger.info(this.tag, str);
    }

    public void d(String fmt, Object ... args) {
        Logger.debug(this.tag, Logger.expand(fmt, args));
    }

    public void d(String str) {
        Logger.debug(this.tag, str);
    }

    public void v(String fmt, Object ... args) {
        Logger.verbose(this.tag, Logger.expand(fmt, args));
    }

    public void v(String str) {
        Logger.verbose(this.tag, str);
    }

    public String getTag() {
        return this.tag;
    }
}

