/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.logging;

import android.text.TextUtils;
import android.util.Log;
import com.airg.android.logging.TaggedLogger;
import java.util.Arrays;
import java.util.Locale;

public final class Logger {
    private static final String TAG = "LOG";
    private static int rootLevel;

    public static TaggedLogger tag(String tag) {
        return new TaggedLogger(tag);
    }

    public static void e(String tag, Throwable throwable) {
        Logger.e(tag, throwable, null);
    }

    public static void e(String tag, Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.error(tag, Logger.format(throwable, msg));
    }

    public static void w(String tag, Throwable throwable) {
        Logger.w(tag, throwable, null);
    }

    public static void w(String tag, Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.warn(tag, Logger.format(throwable, msg));
    }

    public static void d(String tag, Throwable throwable) {
        Logger.d(tag, throwable, null);
    }

    public static void d(String tag, Throwable throwable, String msg) {
        Logger.logThrowable(throwable);
        Logger.debug(tag, Logger.format(throwable, msg));
    }

    public static void e(String tag, String fmt, Object ... args) {
        Logger.error(tag, Logger.expand(fmt, args));
    }

    public static void e(String tag, String str) {
        Logger.error(tag, str);
    }

    public static void w(String tag, String fmt, Object ... args) {
        Logger.warn(tag, Logger.expand(fmt, args));
    }

    public static void w(String tag, String str) {
        Logger.warn(tag, str);
    }

    public static void i(String tag, String fmt, Object ... args) {
        Logger.info(tag, Logger.expand(fmt, args));
    }

    public static void i(String tag, String str) {
        Logger.info(tag, str);
    }

    public static void d(String tag, String fmt, Object ... args) {
        Logger.debug(tag, Logger.expand(fmt, args));
    }

    public static void d(String tag, String str) {
        Logger.debug(tag, str);
    }

    public static void v(String tag, String fmt, Object ... args) {
        Logger.verbose(tag, Logger.expand(fmt, args));
    }

    public static void v(String tag, String str) {
        Logger.verbose(tag, str);
    }

    static String expand(String fmt, Object ... args) {
        try {
            return TextUtils.isEmpty((CharSequence)fmt) ? Arrays.toString(args) : (null == args || args.length == 0 ? fmt : String.format(Locale.ENGLISH, fmt, args));
        }
        catch (Exception e) {
            Logger.d(TAG, e, "Log format failed");
            return Arrays.toString(args);
        }
    }

    public static String format(Throwable t, String msg) {
        return msg + '\n' + Log.getStackTraceString((Throwable)t);
    }

    static void logThrowable(Throwable throwable) {
        if (null == throwable) {
            return;
        }
        throwable.printStackTrace();
    }

    static void debug(String tag, String str) {
        Logger.logAs(3, tag, str);
    }

    static void verbose(String tag, String str) {
        Logger.logAs(2, tag, str);
    }

    static void info(String tag, String str) {
        Logger.logAs(4, tag, str);
    }

    static void error(String tag, String str) {
        Logger.logAs(6, tag, str);
    }

    static void warn(String tag, String str) {
        Logger.logAs(5, tag, str);
    }

    private static void logAs(int level, String tag, String msg) {
        if (level < rootLevel) {
            return;
        }
        String loggableMessage = null == msg ? "<null>" : msg;
        switch (level) {
            case 3: {
                Log.d((String)tag, (String)loggableMessage);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)loggableMessage);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)loggableMessage);
                break;
            }
            case 2: {
                Log.v((String)tag, (String)loggableMessage);
                break;
            }
            default: {
                Log.i((String)tag, (String)loggableMessage);
            }
        }
    }

    private Logger() {
    }

    public static void setRootLevel(int rootLevel) {
        Logger.rootLevel = rootLevel;
    }
}

