/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.promise;

import android.support.annotation.Nullable;
import com.airg.android.async.promise.Promise;
import com.airg.android.logging.Logger;
import com.airg.android.logging.TaggedLogger;
import java.util.concurrent.Executor;

public class SimplePromise<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private static final TaggedLogger LOG = Logger.tag((String)"ASYNC:SP");
    private Promise.OnCompleteListener<RESULT> onCompleteListener;
    private Promise.OnFailListener onFailListener;
    private Promise.OnCancelListener onCancelListener;
    private volatile Throwable error = null;
    private volatile RESULT result = null;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private final Executor callbackExecutor;

    public SimplePromise() {
        this(null);
    }

    public SimplePromise(@Nullable Executor executor) {
        this.callbackExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(RESULT r) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                LOG.d("Promise has been cancelled. Ignoring result.");
                return;
            }
            LOG.d("Promise kept: %s", new Object[]{r});
            this.done = true;
            this.result = r;
            this.notifyDoneMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable t) {
        Object object = this.$lock;
        synchronized (object) {
            this.assertNotComplete();
            if (this.cancelled) {
                LOG.d("Promise has been cancelled. Ignoring failure.");
                return;
            }
            LOG.d(t, "Promise broken");
            this.error = t;
            this.done = true;
            this.notifyFailedMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelled() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.done || this.isFailed()) {
                LOG.d("Ignoring cancel request (already %s)", new Object[]{this.done ? "done" : "failed"});
                return;
            }
            LOG.d("Promise cancelled.");
            this.cancelled = true;
            this.done = true;
            this.notifyCancelledMaybe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCompleteListener = listener;
            this.notifyDoneMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onFailListener = listener;
            this.notifyFailedMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimplePromise<RESULT> onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.onCancelListener = listener;
            this.notifyCancelledMaybe();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean succeeded() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done && null != this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return this.done && null != this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.$lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    private void assertNotComplete() {
        if (this.isDone()) {
            throw new IllegalStateException("Already marked as " + (null == this.error ? "done" : "failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDoneMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.done || null == this.onCompleteListener || this.cancelled) {
                return;
            }
            LOG.d("Notifying promise completion");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onCompleteListener.onComplete(SimplePromise.this.result);
                }
            }, this.callbackExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailedMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isFailed() || null == this.onFailListener || this.cancelled) {
                return;
            }
            LOG.d("Notifying promise failure");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onFailListener.onFailed(SimplePromise.this.error);
                }
            }, this.callbackExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelledMaybe() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.cancelled || null == this.onCancelListener) {
                return;
            }
            LOG.d("Notifying promise cancellation");
            SimplePromise.runOnExecutor(new Runnable(){

                @Override
                public void run() {
                    SimplePromise.this.onCancelListener.onCancelled();
                }
            }, this.callbackExecutor);
        }
    }

    private static void runOnExecutor(Runnable task, Executor executor) {
        if (null == executor) {
            task.run();
        } else {
            executor.execute(task);
        }
    }
}

