/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.promise;

import com.airg.android.async.promise.Promise;
import com.airg.android.async.promise.SimplePromise;
import com.airg.android.logging.Logger;
import com.airg.android.logging.TaggedLogger;
import java.util.concurrent.Executor;

public abstract class AbstractPromise<RESULT>
implements Promise<RESULT>,
Runnable {
    protected static final TaggedLogger LOG = Logger.tag((String)"ASYNC:AP");
    private final SimplePromise<RESULT> promise;

    private AbstractPromise(SimplePromise<RESULT> p) {
        this.promise = p;
    }

    protected AbstractPromise() {
        this(new SimplePromise());
    }

    protected AbstractPromise(Executor executor) {
        this(new SimplePromise(executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            RESULT result = this.result();
            SimplePromise<RESULT> simplePromise = this.promise;
            synchronized (simplePromise) {
                if (this.promise.isCancelled()) {
                    return;
                }
                this.promise.success(result);
            }
        }
        catch (Exception e) {
            LOG.e((Throwable)e);
            SimplePromise<RESULT> simplePromise = this.promise;
            synchronized (simplePromise) {
                this.promise.failed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        SimplePromise<RESULT> simplePromise = this.promise;
        synchronized (simplePromise) {
            if (this.promise.isCancelled()) {
                return;
            }
            try {
                this.abort();
            }
            catch (Exception e) {
                LOG.e((Throwable)e, "abort() failed.");
            }
            finally {
                this.promise.cancelled();
            }
        }
    }

    protected abstract RESULT result() throws Exception;

    protected void abort() {
    }

    @Override
    public AbstractPromise<RESULT> onComplete(Promise.OnCompleteListener<RESULT> listener) {
        this.promise.onComplete((Promise.OnCompleteListener)listener);
        return this;
    }

    @Override
    public AbstractPromise<RESULT> onFail(Promise.OnFailListener listener) {
        this.promise.onFail(listener);
        return this;
    }

    @Override
    public AbstractPromise<RESULT> onCancel(Promise.OnCancelListener listener) {
        this.promise.onCancel(listener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        SimplePromise<RESULT> simplePromise = this.promise;
        synchronized (simplePromise) {
            return this.promise.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean succeeded() {
        SimplePromise<RESULT> simplePromise = this.promise;
        synchronized (simplePromise) {
            return this.promise.succeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        SimplePromise<RESULT> simplePromise = this.promise;
        synchronized (simplePromise) {
            return this.promise.isFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        SimplePromise<RESULT> simplePromise = this.promise;
        synchronized (simplePromise) {
            return this.promise.isCancelled();
        }
    }
}

