/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async;

import android.support.annotation.NonNull;
import com.airg.android.async.CPUWorkerThreadFactory;
import com.airg.android.async.UIThreadExecutor;
import com.airg.android.device.Device;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class ThreadPool {
    private static final Object $LOCK = new Object[0];
    private static final Executor UI = new UIThreadExecutor();
    private static ExecutorService BACKGROUND;
    private static final String DEFAULT_THREAD_PREFIX = "AsyncWorker";
    private static final int DEFAULT_THREAD_PRIORITY = 5;
    private static final int NO_POOL_SIZE_OVERRIDE = 0;

    public static void fg(@NonNull Runnable runnable) {
        UI.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bg(@NonNull Runnable runnable) {
        Object object = $LOCK;
        synchronized (object) {
            ThreadPool.background().execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> submit(@NonNull Runnable runnable) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(@NonNull Callable<T> callable) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(@NonNull Runnable runnable, T result) {
        Object object = $LOCK;
        synchronized (object) {
            return ThreadPool.background().submit(runnable, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService background() {
        Object object = $LOCK;
        synchronized (object) {
            if (null == BACKGROUND) {
                ThreadPool.init(null);
            }
            return BACKGROUND;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor foreground() {
        Object object = $LOCK;
        synchronized (object) {
            return UI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Config config) {
        Object object = $LOCK;
        synchronized (object) {
            int poolSize;
            if (null != BACKGROUND) {
                throw new IllegalStateException("Thread pool already initialized. You should call this method before any other calls to this class' methods");
            }
            Config initConfig = null == config ? new Config() : config;
            int n = poolSize = initConfig.overridePoolSize > 0 ? initConfig.overridePoolSize : Math.max(1, Device.CPU_COUNT - 1);
            if (poolSize <= 0) {
                throw new IllegalArgumentException("Invalid pool size: " + poolSize);
            }
            BACKGROUND = Executors.newFixedThreadPool(poolSize, new CPUWorkerThreadFactory(initConfig.workerThreadNamePrefix, initConfig.backgroundThreadPriority));
        }
    }

    public static class Config {
        private String workerThreadNamePrefix = "AsyncWorker";
        private int overridePoolSize = 0;
        private int backgroundThreadPriority = 5;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        private Config() {
        }

        Config(String workerThreadNamePrefix, int overridePoolSize, int backgroundThreadPriority) {
            this.workerThreadNamePrefix = workerThreadNamePrefix;
            this.overridePoolSize = overridePoolSize;
            this.backgroundThreadPriority = backgroundThreadPriority;
        }

        public static class ConfigBuilder {
            private String prefix = "AsyncWorker";
            private int poolSize = 0;
            private int threadPriority = 5;

            ConfigBuilder() {
            }

            public ConfigBuilder workerThreadNamePrefix(String workerThreadNamePrefix) {
                this.prefix = workerThreadNamePrefix;
                return this;
            }

            public ConfigBuilder overridePoolSize(int overridePoolSize) {
                this.poolSize = overridePoolSize;
                return this;
            }

            public ConfigBuilder backgroundThreadPriority(int backgroundThreadPriority) {
                this.threadPriority = backgroundThreadPriority;
                return this;
            }

            public Config build() {
                return new Config(this.prefix, this.poolSize, this.threadPriority);
            }
        }
    }
}

