/*
 * Decompiled with CFR 0.152.
 */
package com.airg.android.async.future;

import com.airg.android.async.future.Promise;
import com.airg.android.async.future.SimplePromise;
import com.airg.android.logging.Logger;
import com.airg.android.logging.TaggedLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;

public final class FuturePromise<RESULT>
extends FutureTask<RESULT>
implements Promise<RESULT> {
    private final Object $lock = new Object[0];
    private static final TaggedLogger LOG = Logger.tag((String)"ASYNC:FP");
    private final SimplePromise<RESULT> delegate;

    public FuturePromise(Callable<RESULT> callable) {
        this(callable, null);
    }

    public FuturePromise(Callable<RESULT> callable, Executor executor) {
        super(callable);
        this.delegate = new SimplePromise(executor);
    }

    public FuturePromise(Runnable runnable, RESULT resultHolder) {
        this(runnable, resultHolder, null);
    }

    public FuturePromise(Runnable runnable, RESULT resultHolder, Executor executor) {
        super(runnable, resultHolder);
        this.delegate = new SimplePromise(executor);
    }

    @Override
    public boolean succeeded() {
        return this.isDone() && !this.isFailed() && !this.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FuturePromise<RESULT> onComplete(Promise.OnCompleteListener<RESULT> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.delegate.onComplete((Promise.OnCompleteListener)listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FuturePromise<RESULT> onFail(Promise.OnFailListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.delegate.onFail(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FuturePromise<RESULT> onCancel(Promise.OnCancelListener listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.delegate.onCancel(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.$lock;
        synchronized (object) {
            return this.delegate.isFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        Object object = this.$lock;
        synchronized (object) {
            super.done();
            if (this.isCancelled()) {
                LOG.d("FuturePromise completed due to cancellation");
                this.delegate.cancelled();
            } else {
                try {
                    this.delegate.success(this.get());
                    LOG.d("FuturePromise completed");
                }
                catch (ExecutionException ee) {
                    LOG.e("FuturePromise failed.");
                    this.delegate.failed(ee.getCause());
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to get result", e);
                }
            }
        }
    }
}

